///////////////////////////////////////////
// Main Sidebar Variables
///////////////////////////////////////////


///////////////////////////////////////////
// Registry Variables and Widget Objects
///////////////////////////////////////////
var shell = new ActiveXObject("WScript.Shell");

//to-do: replace with HKEY_LOCAL_MACHINE
var BASE_REG_PATH = "HKEY_LOCAL_MACHINE\\Software\\Intel\\Turbo Memory\\Dashboard\\";
var BASE64_REG_PATH = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Intel\\Turbo Memory\\Dashboard\\";
var str_PercentFree="resource.js\str_PercentFree";
var str_SpaceFree="resource.js\str_SpaceFree";
var str_full="resource.js\str_full";
var str_Used="resource.js\str_Used";

// Visualizer Object

var REG_PATH_APPLICATIONPATH = "ApplicationPath";
var REG_PATH_CURRENTPROFILE = "CurrentProfile";
var REG_PATH_PERCENTFULL = "PercentFull";
var REG_PATH_PERCENTFREE = "PercentFree";
var REG_PATH_SPACEUSED = "SpaceUsed";
var REG_PATH_SPACEFREE = "SpaceFree";
var REG_PATH_SPACEFREEUNITS = "SpaceFreeUnits";
var REG_PATH_SPACEUSEDUNITS = "SpaceUsedUnits";
var REG_PATH_ACTIVESTATE = "ActiveState";
var APPLICATION_LAUNCHER_COMMAND = "\\ITMSystray.exe STARTDASHBOARD";

var lastPercentFull = 100;
var lastPercentFree = 0;
var lastSpaceUsed = 0;
var lastSpaceFree = 0;
var lastCurrentProfile = '';
var lastActiveState = 123;

//var activeState; //0-3. default to 1.
var configuredFlag = true;

var i=0;

///////////////////////////////////////////
// Gadget Initialization
///////////////////////////////////////////
function LoadGadget()
{
	// Begin widget cycling
	CheckForRegistryUpdates();
	
		//default to gadget's preferred state first, and the app's state 2nd
		var thisActiveState = System.Gadget.Settings.read("activeState");
		if (thisActiveState == "") {
	
			thisActiveState = ReadRegistryValue(REG_PATH_ACTIVESTATE);
		}
		if (thisActiveState == "") {
			thisActiveState = 1;
		}
		lastActiveState = thisActiveState;
		System.Gadget.Settings.write("activeState", thisActiveState);

	ShowVisState();
			
			
	//set application path info			
	var thisApplicationPath = ReadRegistryValue(REG_PATH_APPLICATIONPATH);
	if (thisApplicationPath == "") {
		thisApplicationPath = "C:\\robson\\intel_robson.exe";  //**REPLACE**
	}

	// Specify the file used to create the settings dialog and function to run when it has closed
	//System.Gadget.settingsUI = "settings.html";
	//System.Gadget.onShowSettings = ProcessSettingsOpeningEvent;
	//System.Gadget.onSettingsClosed = SettingsClosed;
}

function CheckForRegistryUpdates()
{
	
	timerReadRegistry = setTimeout(CheckForRegistryUpdates,50);

	//thisActiveState = parseInt(ReadRegistryValue(REG_PATH_ACTIVESTATE));
	//var thisActiveState = parseInt(System.Gadget.Settings.read("activeState"));
	var thisActiveState = lastActiveState.toString();

	var thisCurrentProfile = ReadRegistryValue(REG_PATH_CURRENTPROFILE);
	var thisPercentFull = ReadRegistryValue(REG_PATH_PERCENTFULL);
	var thisPercentFree = ReadRegistryValue(REG_PATH_PERCENTFREE);
	var thisSpaceUsed = ReadRegistryValue(REG_PATH_SPACEUSED);
	var thisSpaceFree = ReadRegistryValue(REG_PATH_SPACEFREE);
	var thisSpaceFreeUnits = ReadRegistryValue(REG_PATH_SPACEFREEUNITS);
	var thisSpaceUsedUnits = ReadRegistryValue(REG_PATH_SPACEUSEDUNITS);

	if (thisPercentFull == "" && thisPercentFree == "" && thisSpaceUsed == "" && thisSpaceFree == "") {
		showUnconfigured();
		configuredFlag = false;
		return;
	} else {
		if (configuredFlag == false) {
			showConfigured();
			configuredFlag = true;
		}
	}

	if (thisActiveState == "0") {
		
			//PERCENT FREE
			if (lastPercentFree != parseInt(thisPercentFree)) {
				percentFree = parseInt(thisPercentFree);
				updateProgressIndicator(percentFree);
				lastPercentFree = percentFree;
				value.innerHTML = percentFree;
			}
	} else if (thisActiveState == "1") {
		
		//PERCENT FULL
		if (lastPercentFull != parseInt(thisPercentFull)) {
				percentFull = parseInt(thisPercentFull);
				updateProgressIndicator(percentFull);
				lastPercentFull = percentFull;
				value.innerHTML = percentFull;
		}
		
	} else if (thisActiveState == "2") {
		//SPACE FREE
		if (lastSpaceFree != parseInt(thisSpaceFree)) {
				spaceFree = parseInt(thisSpaceFree);
				updateProgressIndicator(parseInt(thisPercentFree));
				lastSpaceFree = spaceFree;
				value.innerHTML = spaceFree;
		}

	} else if (thisActiveState == "3") {
		//SPACE USED
		if (lastSpaceUsed != parseInt(thisSpaceUsed)) {
				spaceUsed = parseInt(thisSpaceUsed);
				lastSpaceUsed = spaceUsed;
				updateProgressIndicator(parseInt(thisPercentFull));
				value.innerHTML = spaceUsed;
		}
	}
	
	if (lastCurrentProfile != thisCurrentProfile) {
		lastCurrentProfile = thisCurrentProfile;
		
		thisProfileNameCont = document.getElementById('profile-name-cont');
		thisProfileName = document.getElementById('profile-name');
		
		
		//** TRUNCATE LONG PROFILE NAMES **
		//hide, get height, truncate if width is too long, show
		
		thisProfileName.style.visibility = 'hidden';
		thisProfileName.innerHTML = thisCurrentProfile;

		if (thisProfileName.offsetWidth > 106) {
			var w = thisProfileName.offsetWidth;
			//strip 1 character off at a time and remeasure width until text area is within the correct width
			while (w > 108) {
				thisCurrentProfile = thisCurrentProfile.substr(0, (thisCurrentProfile.length - 1));
				thisProfileName.innerHTML = thisCurrentProfile;
				w = thisProfileName.offsetWidth;
			}
			thisProfileName.innerHTML = thisCurrentProfile.substr(0, (thisCurrentProfile.length - 1))+'<span style=\"font-size: 60%; font-weight: bold\">&hellip;</span>';
		}
		thisProfileName.style.visibility = 'visible';
		

		//truncate by character counting (imprecise)
//		if (thisCurrentProfile.length > 22) {
//			displayString = thisCurrentProfile.substr(0,21)+'<span style=\"font-size: 60%; font-weight: bold\">&hellip;</span>';
//		} else {
//			displayString = thisCurrentProfile;
//		}
		

	}
	ShowVisState();

}

function showUnconfigured() {
	unconfigured.style.display = 'block';
	readout.style.display = 'none';
	state.style.display = 'none';
	thisHeading = document.getElementById('profile-heading');
	thisName = document.getElementById('profile-name');
	thisConfigure = document.getElementById('app-configure');
	thisHeading.style.display = 'none';
	thisName.style.display = 'none';
	thisConfigure.style.display = 'block';
}
function showConfigured() {
	//i++;
	//debugArea.innerHTML = i;
	unconfigured.style.display = 'none';
	readout.style.display = 'block';
	state.style.display = 'block';
	thisHeading = document.getElementById('profile-heading');
	thisName = document.getElementById('profile-name');
	thisConfigure = document.getElementById('app-configure');
	thisHeading.style.display = 'block';
	thisName.style.display = 'block';
	thisConfigure.style.display = 'none';
}

function updateProgressIndicator(percentFull) {
	
	if (percentFull < 10) {
		indicator.src = 'images/viz-00'+percentFull+'.png';
	} else if (percentFull < 100 && percentFull >= 10 ) {
		indicator.src = 'images/viz-0'+percentFull+'.png';
	} else if (percentFull == 100) {
		indicator.src = 'images/viz-100.png';
	}
		
}



function ShowVisState() {
	
	//accepts 0-3 string
	
	var thisCurrentProfile = ReadRegistryValue(REG_PATH_CURRENTPROFILE);
	var thisPercentFull = ReadRegistryValue(REG_PATH_PERCENTFULL);
	var thisPercentFree = ReadRegistryValue(REG_PATH_PERCENTFREE);
	var thisSpaceUsed = ReadRegistryValue(REG_PATH_SPACEUSED);
	var thisSpaceFree = ReadRegistryValue(REG_PATH_SPACEFREE);
	var thisSpaceFreeUnits = ReadRegistryValue(REG_PATH_SPACEFREEUNITS);
	var thisSpaceUsedUnits = ReadRegistryValue(REG_PATH_SPACEUSEDUNITS);
	
	//var thisActiveState = System.Gadget.Settings.read("activeState");
	var thisActiveState = lastActiveState.toString();
		
		//change units (%, MB, GB), change state indicator (FULL, FREE, USED), change values, change indicator
		
		thisState = document.getElementById('state');
		thisUnits = document.getElementById('units');
		thisValue = document.getElementById('value');

		if (thisActiveState == "0") {
			thisState.innerHTML = str_PercentFree;
			thisUnits.innerHTML = "%";
			thisUnits.style.marginLeft = '0';
			thisValue.innerHTML = thisPercentFree;
			updateProgressIndicator(parseInt(thisPercentFree));
		} else if (thisActiveState == "1") {
	
			thisState.innerHTML = str_full;
			thisUnits.innerHTML = "%";
			thisUnits.style.marginLeft = '0';
			thisValue.innerHTML = thisPercentFull;
			updateProgressIndicator(parseInt(thisPercentFull));
		} else if (thisActiveState == "2") {
			thisState.innerHTML = str_SpaceFree;			
			thisUnits.innerHTML = thisSpaceFreeUnits;
			thisUnits.style.marginLeft = '1px';
			thisValue.innerHTML = thisSpaceFree;
			updateProgressIndicator(parseInt(thisPercentFree));
		}else if (thisActiveState == "3") {			
			thisState.innerHTML = str_Used;			
			thisUnits.innerHTML = thisSpaceUsedUnits;
			thisUnits.style.marginLeft = '1px';
			thisValue.innerHTML = thisSpaceUsed;
			updateProgressIndicator(parseInt(thisPercentFull));
		}
		
}
function IncrVisState() {
	
	//var thisActiveState = System.Gadget.Settings.read("activeState");
	var thisActiveState = parseInt(lastActiveState);

	if (thisActiveState >= 0 && thisActiveState < 3) {
		thisActiveState = thisActiveState + 1;
	} else if (thisActiveState == 3) {
		thisActiveState = 0;
	}

	System.Gadget.Settings.write("activeState", thisActiveState);
	lastActiveState = thisActiveState.toString();
	ShowVisState();
}
function ReadRegistryValue(strRegistryName)
{
	// Read name/value pair from registry
    var RegistryValue=0;
    
	try
	{
	    Proc = shell.ExpandEnvironmentStrings("%PROCESSOR_ARCHITECTURE%");
	    if (Proc == "x86") {
		    RegistryValue = String(shell.RegRead(BASE_REG_PATH + strRegistryName) );
		} 
		if (Proc == "AMD64")
		{
			if(strRegistryName==REG_PATH_APPLICATIONPATH){
				RegistryValue = String(shell.RegRead(BASE_REG_PATH + strRegistryName) );
			}
			else{
		    		RegistryValue = String(shell.RegRead(BASE64_REG_PATH + strRegistryName) );
			}	
		}
	}
	catch(error)
	{
	    // Doesn't seem to work anyway. At least an exception isn't thrown if the RegRead function can't find key
	}
	return RegistryValue;
}

function WriteRegistryValue(strRegistryName,strRegistryValue)
{
	// Write name/value pair to registry
	try
	{
	    Proc = shell.ExpandEnvironmentStrings("%PROCESSOR_ARCHITECTURE%");
	    if (Proc == "x86") {
		    shell.RegWrite(BASE_REG_PATH + strRegistryName, strRegistryValue, "REG_SZ");
		}
		if (Proc == "AMD64")
		{
		    shell.RegWrite(BASE64_REG_PATH + strRegistryName, strRegistryValue, "REG_SZ");
		}
	}
	catch(error)
	{
	    shell.RegWrite(BASE_REG_PATH + strRegistryName, strRegistryValue, "REG_SZ");
	}
}

function ProfileHighlight(showFlag) {
	thisProfile = document.getElementById('hit');
	
	if (showFlag) {
		thisProfile.style.background = "url('../images/profile-hi.png')";
	} else {
		thisProfile.style.background = '';
	}

}

///////////////////////////////////////////
// Run Intel Robson
///////////////////////////////////////////
function RunRobson()
{
    var thisApplicationPath = ReadRegistryValue(REG_PATH_APPLICATIONPATH) + APPLICATION_LAUNCHER_COMMAND;

    shell.Exec(thisApplicationPath);
}