﻿//vars
var MaxxAudio;
var CurrentSlide = 1;
var Step = 21; //slide height
var SlidesNumber;
var SPEED = 350;

var NextSlide;
var AnimateArgs;
var NextPos;
var SeetingsTogle=0;
var BypassAllStatus;
var InactiveState = false;

var LastHTML;
var LastStateOfButton = false;

//const
var BYPASS_ALL = 1; //1 is Off, 0 is On
var BYPASS_BTN_ON = 0;
var BYPASS_BTN_OFF = 1;

$("document").ready(function()
{
	try
	{
		MaxxAudio = new ActiveXObject("MaxxGadget.GadgetObject");
		MaxxAudio.Initialize("APOVSDRenderGFX", 0, "");
	}
	catch(e)
	{
		//
	}
	
    MaxxAudio.RegisterParameterChangeNotification(OnParameterChanged);
	
	//on_off btn init
	OnOffInit(true);
	
	//on_off btn click init
	OnOffClickInit();
	
	// Init select box
	SelectBoxInit();

	//settings button init
	SettingsBtnInit();

	Jump(1);
	
	//init select box onclick
	SelectBoxClickInit();
	SettingsClickInit();

	OnParameterChanged(0, 0);
});
	
// --------------------------------------------------------------------
// Handle the Settings dialog show event.
// --------------------------------------------------------------------
function OnParameterChanged(aaa, bbb)
{
    SelectBoxInit();
    OnOffInit(false);
    
    nSoundMode = MaxxAudio.GetSoundMode();
    
    Jump(nSoundMode + 1)
}

//settings button init
function SettingsBtnInit()
{
	document.getElementById('settings_btn').style.display = "none";	
	
	$("body").get(0).onmouseover = function()
	{
		document.getElementById('settings_btn').style.display = "";	
	}
	$("body").get(0).onmouseout = function()
	{
		document.getElementById('settings_btn').style.display = "none";	
	}	
	
}

function GetTitle(id)
{

	var title = MaxxAudio.GetSoundModeName(id);
	if (title == "disabled")
	{
		title = "Inactive";
		
		if (!InactiveState)
		{
			//button disabled
			InactiveState = true;
		
			//title
			$("#wrapper").attr("title", "MaxxAudio processes internal speakers output only");
		}
	}
	else
	{
		if (InactiveState)
		{		
			//button enabled
			InactiveState = false;
		
			//empty title
			$("#wrapper").attr("title", "");
		}
	}

	return title;
}

//init select box
function SelectBoxInit()
{
	var presets_num;
	var preset;
	var html = "";
	
	// Get presets count
	presets_num = MaxxAudio.GetSoundModeCount();
		
	// Create html
	html += "<ul class=\"SelectBoxUl\">";

	html += "<li id=\"Slide" + i + "\">";
    html += GetTitle(presets_num - 1);
	html += "</li>";

	for(var i=0; i<presets_num; i++)	
	{
		html += "<li id=\"Slide" + i + "\">";
		
		try
		{
			html += GetTitle(i);
		}
		catch(e)	
		{
			//
		}
		html += "</li>";
	}

	html += "<li id=\"Slide" + i + "\">";
    html += GetTitle(0);
	html += "</li>";
    
	html += "</ul>";		
	
	//set html
	if (LastHTML != html)
	{
    	$("div#SelectBoxContent").html(html);

	    //get slides number
    	SlidesNumber = $("div#SelectBoxContent ul li").length;
    	
    	LastHTML = html;
    }
    else
    {
    }

	if (presets_num == 1)
	{
		document.getElementById('left_arrow').style.display = 'none';	
		document.getElementById('right_arrow').style.display = 'none';	
		$("div#SelectBoxContent").css("width", 100);
		$("ul.SelectBoxUl").css("width", 100);
		$("ul.SelectBoxUl li").css("width", 100);
		$("ul.SelectBoxUl li").css("text-align", "center");
	} 
	else
	{
		document.getElementById('left_arrow').style.display = "";	
		document.getElementById('right_arrow').style.display = "";	
		$("div#SelectBoxContent").css("width", 60);
		$("ul.SelectBoxUl").css("width", 60);
		$("ul.SelectBoxUl li").css("width", 60);
	}
}


//init select box onclick
function SelectBoxClickInit()
{
	$("#right_arrow").click(function()
	{			
		if (eval(CurrentSlide) + 1 < SlidesNumber)
		{
   			Jump(CurrentSlide);
   			
			NextSlide = eval(CurrentSlide) + 1;
			NextPos = -1*Step*NextSlide;
					
			AnimateArgs = {top:NextPos};
			$("div#SelectBoxContent ul").animate(AnimateArgs, SPEED);
			CurrentSlide = eval(CurrentSlide) + 1;
			
    		if (eval(CurrentSlide) + 1 >= SlidesNumber)
    		{
    		    // Got to the last item, scroll back to the first
    			Jump(1);
    		}

			//set preset
			SetPreset(CurrentSlide - 1);
		}
		
		return false;		
	});	
	
	$("#left_arrow").click(function()
	{		
		if (eval(CurrentSlide) - 1 >= 0)
		{
   			Jump(CurrentSlide);

			NextSlide = eval(CurrentSlide) - 1;
			NextPos = -1*Step*NextSlide;
			
			//$("div#test").html(NextPos);			
			AnimateArgs = {top:NextPos};
			$("div#SelectBoxContent ul").animate(AnimateArgs, SPEED);
			CurrentSlide = eval(CurrentSlide) - 1;

    		if (eval(CurrentSlide) <= 0)
    		{
    		    // Got to the last item, scroll back to the first
    			Jump(SlidesNumber - 2);
    		}

			//set preset
			SetPreset(CurrentSlide - 1);
		}
		
		return false;
	});

}

//jump 
function Jump(SlideIndex)
{
	if (SlideIndex >= 0 && SlideIndex < SlidesNumber)
	{
		NextSlide = SlideIndex;
		NextPos = -1*Step*NextSlide;
		$("div#SelectBoxContent ul").css("top", NextPos);
		CurrentSlide = NextSlide;
	}
}


//set preset
function SetPreset(nIndex)
{
	//set preset
	MaxxAudio.SetSoundMode(nIndex);
    MaxxAudio.SetParameter(BYPASS_ALL, BypassAllStatus);
}

//on_off btn init
function OnOffInit(bForceUpdate)
{
	//get bypas state
	BypassAllStatus = MaxxAudio.GetParameter(BYPASS_ALL);
	
	StateIsOff = InactiveState || BypassAllStatus != BYPASS_BTN_ON;
	
	if (bForceUpdate || LastStateOfButton != StateIsOff)
	{
		LastStateOfButton = StateIsOff;
		
		if (StateIsOff)
		{
			$("#on_off_btn").css("background-image", "url(../images/btn_ma_off.png)");
		}
		else
		{
			$("#on_off_btn").css("background-image", "url(../images/btn_ma_on.png)");
		}
	}
	
}

//on_off btn click init
function SettingsClickInit()
{
	$("#settings_btn").get(0).onclick = function()
	{
	    MaxxAudio.OpenSettings(0, 0);
	}
}
//on_off btn click init
function OnOffClickInit()
{
	$("#on_off_btn").get(0).onclick = function()
	{
		if (!InactiveState)
		{
			if (BypassAllStatus == BYPASS_BTN_ON)
			{
				//close it
				$("#on_off_btn").css("background-image", "url(../images/btn_ma_off.png)");
				MaxxAudio.SetParameter(BYPASS_ALL, BYPASS_BTN_OFF);
				BypassAllStatus = BYPASS_BTN_OFF;
			}
			else //BYPASS_BTN_OFF
			{
				//open it
				$("#on_off_btn").css("background-image", "url(../images/btn_ma_on.png)");
				MaxxAudio.SetParameter(BYPASS_ALL, BYPASS_BTN_ON);
				BypassAllStatus = BYPASS_BTN_ON;
			}
			
			//restore select box position
			Jump(CurrentSlide);	
		}
	}
}
