/*

  This file is provided under a dual BSD/GPLv2 license.  When using or
  redistributing this file, you may do so under either license.

  GPL LICENSE SUMMARY

  Copyright(c) 1999 - 2013 Intel Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
  The full GNU General Public License is included in this distribution
  in the file called LICENSE.GPL.

  Contact Information:
  e1000-devel Mailing List <e1000-devel@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

  BSD LICENSE

  Copyright(c) 1999 - 2013 Intel Corporation. All rights reserved.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/**********************************************************************
*                                                                     *
* Module Name:                                                        *
*   linuxnalioctl.h                                                   *
*                                                                     *
* Abstract:                                                           *
*   Contains the ioctl values for sharing between the user mode app   *
*   and the iqvl32.o driver.                                          *
*                                                                     *
***********************************************************************
* VSS Revision Control Information:
* ---------------------------------
*   $Workfile: linuxnalioctl.h $
*   $Date: 2013/01/16 07:59:53 $
*   $Archive: /QV2.0/nal/inc/linux/linuxnalioctl.h $
*   $Revision: 1.22 $
**********************************************************************/

#ifndef __LINUXNALIOCTL_H__
#define __LINUXNALIOCTL_H__


/* Device can be anything between 0x8000 - 0x10000. 8086 seems appropriate  */
#define DEVICE_NAL          0x8086


/* Device Control Code values between 2048 & 4095 are allowed. */
#define NAL_IOCTL_BASE      2049

//#define NAL_MAKE_IOCTL(IoctlNumber)  (0xC0000000 + (sizeof(NAL_IOCTL_INPUT_DATA)<<16) + NAL_IOCTL_BASE + IoctlNumber)
#define NAL_MAKE_IOCTL(IoctlNumber)  (NAL_IOCTL_BASE + IoctlNumber)

/* Best place to define values common to both driver and sdk. */

/* this should be updated whenever there is a change in linux driver */
#define LINUX_DRIVER_VERSION      "1.1.4.2"

#define NAL_LINUX_MAX_CONTIGUOUS_MEMORY_ALLOCATION  (128 * 1024)

#endif

