/**************************************************************************

Copyright (c) 2016, Intel Corporation

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/

#include <wol.h>

_WOL_DEVICE_INFO_t const WOL_DEVICE_INFO_TABLE[] = {
/* Vendor   DeviceID SubVendor SubSystem  WoL*/
#if defined(WOL_100M)
 { 0x8086, 0x10FE, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82552 10/100 Network Connection */
#endif /* WOL_100M */

#if defined(WOL_1G)
 { 0x8086, 0x1049, 0x1179, 0x0001, 0xF }, /* Intel(R) 82566MM Gigabit Network Connection */
 { 0x8086, 0x1049, 0x8086, 0x1049, 0xF }, /* Intel(R) 82566MM Gigabit Network Connection */
 { 0x8086, 0x1049, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82566MM Gigabit Network Connection */
 { 0x8086, 0x104A, 0x8086, 0x104A, 0xF }, /* Intel(R) 82566DM Gigabit Network Connection */
 { 0x8086, 0x104A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82566DM Gigabit Network Connection */
 { 0x8086, 0x104B, 0x8086, 0x104B, 0xF }, /* Intel(R) 82566DC Gigabit Network Connection */
 { 0x8086, 0x104B, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82566DC Gigabit Network Connection */
 { 0x8086, 0x104C, 0x1179, 0x0001, 0xF }, /* Intel(R) 82562V 10/100 Network Connection */
 { 0x8086, 0x104C, 0x8086, 0x104C, 0xF }, /* Intel(R) 82562V 10/100 Network Connection */
 { 0x8086, 0x104C, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82562V 10/100 Network Connection */
 { 0x8086, 0x104D, 0x1179, 0x0001, 0xF }, /* Intel(R) 82566MC Gigabit Network Connection */
 { 0x8086, 0x104D, 0x8086, 0x104D, 0xF }, /* Intel(R) 82566MC Gigabit Network Connection */
 { 0x8086, 0x104D, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82566MC Gigabit Network Connection */
 { 0x8086, 0x105E, 0x103C, 0x7044, 0x1 }, /* HP NC360T PCIe DP Gigabit Server Adapter */
 { 0x8086, 0x105E, 0x103C, 0x704E, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Server Adapter */
 { 0x8086, 0x105E, 0x8086, 0x005E, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Server Connection */
 { 0x8086, 0x105E, 0x8086, 0x105E, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Network Connection */
 { 0x8086, 0x105E, 0x8086, 0x115E, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Server Adapter */
 { 0x8086, 0x105E, 0x8086, 0x125E, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Server Adapter */
 { 0x8086, 0x105E, 0x8086, 0x135E, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Server Adapter */
 { 0x8086, 0x105E, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) PRO/1000 PT Dual Port Network Connection */
 { 0x8086, 0x105F, 0x103C, 0x704F, 0x1 }, /* Intel(R) PRO/1000 PF Dual Port Server Adapter */
 { 0x8086, 0x105F, 0x8086, 0x005F, 0x1 }, /* Intel(R) PRO/1000 PF Dual Port Server Adapter */
 { 0x8086, 0x105F, 0x8086, 0x115F, 0x1 }, /* Intel(R) PRO/1000 PF Dual Port Server Adapter */
 { 0x8086, 0x105F, 0x8086, 0x125F, 0x1 }, /* Intel(R) PRO/1000 PF Dual Port Server Adapter */
 { 0x8086, 0x105F, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) PRO/1000 PF Dual Port Server Adapter */
 { 0x8086, 0x1060, 0x8086, 0x0060, 0x1 }, /* Intel(R) PRO/1000 PB Dual Port Server Connection */
 { 0x8086, 0x1060, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) PRO/1000 PB Dual Port Server Connection */
 { 0x8086, 0x107D, 0x8086, 0x1082, 0xF }, /* Intel(R) PRO/1000 PT Server Adapter */
 { 0x8086, 0x107D, 0x8086, 0x1084, 0xF }, /* Intel(R) PRO/1000 PT Server Adapter */
 { 0x8086, 0x107D, 0x8086, 0x1092, 0xF }, /* Intel(R) PRO/1000 PT Server Adapter */
 { 0x8086, 0x107D, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PT Network Connection */
 { 0x8086, 0x107E, 0x8086, 0x1084, 0xF }, /* Intel(R) PRO/1000 PF Server Adapter */
 { 0x8086, 0x107E, 0x8086, 0x1085, 0xF }, /* Intel(R) PRO/1000 PF Server Adapter */
 { 0x8086, 0x107E, 0x8086, 0x1094, 0xF }, /* Intel(R) PRO/1000 PF Server Adapter */
 { 0x8086, 0x107E, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PF Network Connection */
 { 0x8086, 0x107F, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PB Server Connection */
 { 0x8086, 0x108B, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x108C, 0x1014, 0x02F6, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x108C, 0x1014, 0x02F9, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x108C, 0x1014, 0x030E, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x108C, 0x1179, 0x0001, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x108C, 0x1179, 0xFF00, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x108C, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PM Network Connection */
 { 0x8086, 0x1096, 0x10F1, 0x2692, 0xF }, /* Intel(R) PRO/1000 EB1 Network Connection with I/O Acceleration */
 { 0x8086, 0x1096, 0x1734, 0x10A8, 0xF }, /* Intel(R) PRO/1000 EB1 Network Connection with I/O Acceleration */
 { 0x8086, 0x1096, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 EB Network Connection with I/O Acceleration */
 { 0x8086, 0x1098, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 EB Backplane Connection with I/O Acceleration */
 { 0x8086, 0x109A, 0x1179, 0x0001, 0xF }, /* Intel(R) PRO/1000 PL Network Connection */
 { 0x8086, 0x109A, 0x1179, 0xFF00, 0xF }, /* Intel(R) PRO/1000 PL Network Connection */
 { 0x8086, 0x109A, 0x17AA, 0x2001, 0xF }, /* Intel(R) PRO/1000 PL Network Connection */
 { 0x8086, 0x109A, 0x17AA, 0x207E, 0xF }, /* Intel(R) PRO/1000 PL Network Connection */
 { 0x8086, 0x109A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PL Network Connection */
 { 0x8086, 0x10A4, 0x8086, 0x10A4, 0x1 }, /* Intel(R) PRO/1000 PT Quad Port Server Adapter */
 { 0x8086, 0x10A4, 0x8086, 0x11A4, 0x1 }, /* Intel(R) PRO/1000 PT Quad Port Server Adapter */
 { 0x8086, 0x10A4, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) PRO/1000 PT Quad Port Server Adapter */
 { 0x8086, 0x10A5, 0x8086, 0x10A5, 0x1 }, /* Intel(R) PRO/1000 PF Quad Port Server Adapter */
 { 0x8086, 0x10A5, 0x8086, 0x10A6, 0x1 }, /* Intel(R) PRO/1000 PF Quad Port Server Adapter */
 { 0x8086, 0x10A5, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) PRO/1000 PF Quad Port Server Adapter */
 { 0x8086, 0x10A7, 0x8086, 0x10A8, 0xF }, /* Intel(R) 82575EB Gigabit Network Connection */
 { 0x8086, 0x10A7, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82575EB Gigabit Network Connection */
 { 0x8086, 0x10A9, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82575EB Gigabit Backplane Connection */
 { 0x8086, 0x10B9, 0x103C, 0x704A, 0xF }, /* HP NC110T PCIe Gigabit Server Adapter */
 { 0x8086, 0x10B9, 0x8086, 0x1083, 0xF }, /* Intel(R) PRO/1000 PT Desktop Adapter */
 { 0x8086, 0x10B9, 0x8086, 0x1093, 0xF }, /* Intel(R) PRO/1000 PT Desktop Adapter */
 { 0x8086, 0x10B9, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 PT Desktop Adapter */
 { 0x8086, 0x10BA, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 EB1 Network Connection with I/O Acceleration */
 { 0x8086, 0x10BB, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) PRO/1000 EB1 Backplane Connection with I/O Acceleration */
 { 0x8086, 0x10BC, 0x103C, 0x704B, 0x1 }, /* HP NC364T PCIe Quad Port Gigabit Server Adapter */
 { 0x8086, 0x10BC, 0x8086, 0x10BC, 0x1 }, /* Intel(R) PRO/1000 PT Quad Port LP Server Adapter */
 { 0x8086, 0x10BC, 0x8086, 0x11BC, 0x1 }, /* Intel(R) PRO/1000 PT Quad Port LP Server Adapter */
 { 0x8086, 0x10BC, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) PRO/1000 PT Quad Port LP Server Adapter */
 { 0x8086, 0x10BD, 0x17AA, 0x1020, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BD, 0x17AA, 0x3031, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BD, 0x17AA, 0x3032, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BD, 0x17AA, 0x3033, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BD, 0x17AA, 0x3034, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BD, 0x8086, 0x10BD, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BD, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82566DM-2 Gigabit Network Connection */
 { 0x8086, 0x10BF, 0x1179, 0x0001, 0xF }, /* Intel(R) 82567LF Gigabit Network Connection */
 { 0x8086, 0x10BF, 0x1179, 0x0002, 0xF }, /* Intel(R) 82567LF Gigabit Network Connection */
 { 0x8086, 0x10BF, 0x8086, 0x10BF, 0xF }, /* Intel(R) 82567LF Gigabit Network Connection */
 { 0x8086, 0x10BF, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LF Gigabit Network Connection */
 { 0x8086, 0x10C0, 0x8086, 0x10C0, 0xF }, /* Intel(R) 82562V-2 10/100 Network Connection */
 { 0x8086, 0x10C0, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82562V-2 10/100 Network Connection */
 { 0x8086, 0x10C2, 0x8086, 0x10C2, 0xF }, /* Intel(R) 82562G-2 10/100 Network Connection */
 { 0x8086, 0x10C2, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82562G-2 10/100 Network Connection */
 { 0x8086, 0x10C3, 0x8086, 0x10C3, 0xF }, /* Intel(R) 82562GT-2 10/100 Network Connection */
 { 0x8086, 0x10C3, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82562GT-2 10/100 Network Connection */
 { 0x8086, 0x10C4, 0x8086, 0x10C4, 0xF }, /* Intel(R) 82562GT 10/100 Network Connection */
 { 0x8086, 0x10C4, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82562GT 10/100 Network Connection */
 { 0x8086, 0x10C5, 0x8086, 0x10C5, 0xF }, /* Intel(R) 82562G 10/100 Network Connection */
 { 0x8086, 0x10C5, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82562G 10/100 Network Connection */
 { 0x8086, 0x10C9, 0x103C, 0x323F, 0xF }, /* HP NC362i Integrated DP Gigabit Server Adapter */
 { 0x8086, 0x10C9, 0x152D, 0x8969, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10C9, 0x152D, 0x8975, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10C9, 0x152D, 0x897A, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10C9, 0x152D, 0x897B, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10C9, 0x8086, 0xA01C, 0x1 }, /* Intel(R) Gigabit ET Dual Port Server Adapter */
 { 0x8086, 0x10C9, 0x8086, 0xA03C, 0x1 }, /* Intel(R) Gigabit ET Dual Port Server Adapter */
 { 0x8086, 0x10C9, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10CA, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82576 Virtual Function */
 { 0x8086, 0x10CB, 0x1179, 0x0001, 0xF }, /* Intel(R) 82567V Gigabit Network Connection */
 { 0x8086, 0x10CB, 0x8086, 0x10CB, 0xF }, /* Intel(R) 82567V Gigabit Network Connection */
 { 0x8086, 0x10CB, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567V Gigabit Network Connection */
 { 0x8086, 0x10CC, 0x8086, 0x10CC, 0xF }, /* Intel(R) 82567LM-2 Gigabit Network Connection */
 { 0x8086, 0x10CC, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LM-2 Gigabit Network Connection */
 { 0x8086, 0x10CD, 0x8086, 0x10CD, 0xF }, /* Intel(R) 82567LF-2 Gigabit Network Connection */
 { 0x8086, 0x10CD, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LF-2 Gigabit Network Connection */
 { 0x8086, 0x10CE, 0x8086, 0x10CE, 0xF }, /* Intel(R) 82567V-2 Gigabit Network Connection */
 { 0x8086, 0x10CE, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567V-2 Gigabit Network Connection */
 { 0x8086, 0x10D3, 0x103C, 0x1785, 0xF }, /* HP NC112i 1-port Ethernet Server Adapter */
 { 0x8086, 0x10D3, 0x103C, 0x3250, 0xF }, /* HP NC112T PCIe Gigabit Server Adapter */
 { 0x8086, 0x10D3, 0x8086, 0x0001, 0xF }, /* Intel(R) Gigabit CT2 Desktop Adapter */
 { 0x8086, 0x10D3, 0x8086, 0xA01F, 0xF }, /* Intel(R) Gigabit CT Desktop Adapter */
 { 0x8086, 0x10D3, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82574L Gigabit Network Connection */
 { 0x8086, 0x10D5, 0x108E, 0xF1BC, 0x1 }, /* Intel(R) Gigabit PT Quad Port Server ExpressModule */
 { 0x8086, 0x10D5, 0xFFFF, 0xFFFF, 0x1 }, /* Intel(R) Gigabit PT Quad Port Server ExpressModule */
 { 0x8086, 0x10D6, 0x8086, 0x147A, 0x1 }, /* Intel(R) Gigabit VT Quad Port Server Adapter */
 { 0x8086, 0x10D9, 0x103C, 0x1716, 0x1 }, /* HP NC360m Dual Port 1GbE BL-c Adapter */
 { 0x8086, 0x10DA, 0x103C, 0x1717, 0x1 }, /* HP NC364m Quad Port 1GbE BL-c Adapter */
 { 0x8086, 0x10DE, 0x8086, 0x10DE, 0xF }, /* Intel(R) 82567LM-3 Gigabit Network Connection */
 { 0x8086, 0x10DE, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LM-3 Gigabit Network Connection */
 { 0x8086, 0x10DF, 0x8086, 0x10DF, 0xF }, /* Intel(R) 82567LF-3 Gigabit Network Connection */
 { 0x8086, 0x10DF, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LF-3 Gigabit Network Connection */
 { 0x8086, 0x10E5, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LM-4 Gigabit Network Connection */
 { 0x8086, 0x10E6, 0x8086, 0xA01F, 0x1 }, /* Intel(R) Gigabit EF Dual Port Server Adapter */
 { 0x8086, 0x10E6, 0x8086, 0xA02F, 0x1 }, /* Intel(R) Gigabit EF Dual Port Server Adapter */
 { 0x8086, 0x10E6, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10E7, 0x103C, 0x31FF, 0xF }, /* HP NC362i Integrated DP BL-c Gigabit Server Adapter */
 { 0x8086, 0x10E7, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82576 Gigabit Dual Port Server Network Connection */
 { 0x8086, 0x10E8, 0x8086, 0xA02B, 0x1 }, /* Intel(R) Gigabit ET Quad Port Server Adapter */
 { 0x8086, 0x10E8, 0x8086, 0xA02C, 0x1 }, /* Intel(R) Gigabit ET Quad Port Server Adapter */
 { 0x8086, 0x10EA, 0x1179, 0x0001, 0xF }, /* Intel(R) 82577LM Gigabit Network Connection */
 { 0x8086, 0x10EA, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82577LM Gigabit Network Connection */
 { 0x8086, 0x10EB, 0x1179, 0x0001, 0xF }, /* Intel(R) 82577LC Gigabit Network Connection */
 { 0x8086, 0x10EB, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82577LC Gigabit Network Connection */
 { 0x8086, 0x10EF, 0x17AA, 0x3053, 0xF }, /* Intel(R) 82578DM Gigabit Network Connection */
 { 0x8086, 0x10EF, 0x17AA, 0x3059, 0xF }, /* Intel(R) 82578DM Gigabit Network Connection */
 { 0x8086, 0x10EF, 0x17AA, 0x3060, 0xF }, /* Intel(R) 82578DM Gigabit Network Connection */
 { 0x8086, 0x10EF, 0x17AA, 0x306A, 0xF }, /* Intel(R) 82578DM Gigabit Network Connection */
 { 0x8086, 0x10EF, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82578DM Gigabit Network Connection */
 { 0x8086, 0x10F0, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82578DC Gigabit Network Connection */
 { 0x8086, 0x10F5, 0x1179, 0x0001, 0xF }, /* Intel(R) 82567LM Gigabit Network Connection */
 { 0x8086, 0x10F5, 0x8086, 0x10F5, 0xF }, /* Intel(R) 82567LM Gigabit Network Connection */
 { 0x8086, 0x10F5, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567LM Gigabit Network Connection */
 { 0x8086, 0x10F6, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82574L Gigabit Network Connection */
 { 0x8086, 0x1501, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567V-3 Gigabit Network Connection */
 { 0x8086, 0x1502, 0x1179, 0x0001, 0xF }, /* Intel(R) 82579LM Gigabit Network Connection */
 { 0x8086, 0x1502, 0x1179, 0x0002, 0xF }, /* Intel(R) 82579LM Gigabit Network Connection */
 { 0x8086, 0x1502, 0x8086, 0x0000, 0xF }, /* Intel(R) 82579LM Gigabit Network Connection */
 { 0x8086, 0x1502, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82579LM Gigabit Network Connection */
 { 0x8086, 0x1503, 0x1179, 0x0001, 0xF }, /* Intel(R) 82579V Gigabit Network Connection */
 { 0x8086, 0x1503, 0x1179, 0x0002, 0xF }, /* Intel(R) 82579V Gigabit Network Connection */
 { 0x8086, 0x1503, 0x8086, 0x0000, 0xF }, /* Intel(R) 82579V Gigabit Network Connection */
 { 0x8086, 0x1503, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82579V Gigabit Network Connection */
 { 0x8086, 0x150A, 0x1734, 0x11A7, 0x1 }, /* Intel(R) 82576NS Gigabit Network Connection */
 { 0x8086, 0x150A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82576NS Gigabit Ethernet Controller */
 { 0x8086, 0x150C, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82583V Gigabit Network Connection */
 { 0x8086, 0x150D, 0x8086, 0xA10C, 0xF }, /* Intel(R) Gigabit ET Quad Port Mezzanine Card */
 { 0x8086, 0x150E, 0x103C, 0x1780, 0x1 }, /* HP NC365T PCIe Quad Port Gigabit Server Adapter */
 { 0x8086, 0x150E, 0x1734, 0x11A8, 0x1 }, /* Intel(R) 82580 Gigabit Network Connection */
 { 0x8086, 0x150E, 0x8086, 0x12A1, 0x1 }, /* Intel(R) Ethernet Server Adapter I340-T4 */
 { 0x8086, 0x150E, 0x8086, 0x12A2, 0x1 }, /* Intel(R) Ethernet Server Adapter I340-T4 */
 { 0x8086, 0x150E, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82580 Gigabit Network Connection */
 { 0x8086, 0x150F, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82580 Gigabit Fiber Network Connection */
 { 0x8086, 0x1510, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82580 Gigabit Backplane Connection */
 { 0x8086, 0x1516, 0x8086, 0x12B1, 0x1 }, /* Intel(R) Ethernet Server Adapter I340-T2 */
 { 0x8086, 0x1516, 0x8086, 0x12B2, 0x1 }, /* Intel(R) Ethernet Server Adapter I340-T2 */
 { 0x8086, 0x1518, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82576NS SerDes Gigabit Ethernet Controller */
 { 0x8086, 0x1520, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) I350 Virtual Function */
 { 0x8086, 0x1521, 0x1028, 0x04CF, 0xF }, /* Intel(R) Gigabit 2P I350-t LOM */
 { 0x8086, 0x1521, 0x1028, 0x0602, 0xF }, /* Intel(R) Gigabit 2P I350-t LOM */
 { 0x8086, 0x1521, 0x1028, 0x1F60, 0xF }, /* Intel(R) Gigabit 4P I350-t rNDC */
 { 0x8086, 0x1521, 0x1028, 0x1F62, 0xF }, /* Intel(R) Gigabit 4P X540/I350 rNDC */
 { 0x8086, 0x1521, 0x1028, 0x1F73, 0xF }, /* Intel(R) Gigabit 4P X520/I350 rNDC */
 { 0x8086, 0x1521, 0x1028, 0x1F9A, 0xF }, /* Intel(R) Gigabit 4P X710/I350 rNDC */
 { 0x8086, 0x1521, 0x103C, 0x17D1, 0xF }, /* HP Ethernet 1Gb 4-port 366FLR Adapter */
 { 0x8086, 0x1521, 0x103C, 0x2003, 0x1 }, /* HP Ethernet 1Gb 2-port 367i Adapter */
 { 0x8086, 0x1521, 0x103C, 0x2226, 0xF }, /* HP Ethernet 1Gb 1-port 364i Adapter */
 { 0x8086, 0x1521, 0x103C, 0x337F, 0xF }, /* HP Ethernet 1Gb 2-port 361i Adapter */
 { 0x8086, 0x1521, 0x103C, 0x3380, 0xF }, /* HP Ethernet 1Gb 4-port 366i Adapter */
 { 0x8086, 0x1521, 0x103C, 0x339E, 0xF }, /* HP Ethernet 1Gb 2-port 361T Adapter */
 { 0x8086, 0x1521, 0x103C, 0x8157, 0x1 }, /* HP Ethernet 1Gb 4-port 366T Adapter */
 { 0x8086, 0x1521, 0x108E, 0x7B16, 0x1 }, /* Sun Quad Port GbE PCIe 2.0 ExpressModule, UTP */
 { 0x8086, 0x1521, 0x108E, 0x7B18, 0x1 }, /* Sun Quad Port GbE PCIe 2.0 Low Profile Adapter, UTP */
 { 0x8086, 0x1521, 0x1137, 0x008A, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x008B, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x008E, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x00B4, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x00D3, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x00D5, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x00D6, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x1137, 0x0133, 0xF }, /* Cisco 1GigE I350 LOM */
 { 0x8086, 0x1521, 0x17AA, 0x1074, 0x1 }, /* Lenovo ThinkServer I350-T4 AnyFabric */
 { 0x8086, 0x1521, 0x8086, 0x0001, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-T4 */
 { 0x8086, 0x1521, 0x8086, 0x0002, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-T2 */
 { 0x8086, 0x1521, 0x8086, 0x00A1, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-T4 */
 { 0x8086, 0x1521, 0x8086, 0x00A2, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-T2 */
 { 0x8086, 0x1521, 0x8086, 0x5001, 0x1 }, /* Intel(R) Gigabit 4P I350-t Adapter */
 { 0x8086, 0x1521, 0x8086, 0x5002, 0x1 }, /* Intel(R) Gigabit 2P I350-t Adapter */
 { 0x8086, 0x1521, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I350 Gigabit Network Connection */
 { 0x8086, 0x1522, 0x108E, 0x7B17, 0x1 }, /* Sun Quad Port GbE PCIe 2.0 ExpressModule, MMF */
 { 0x8086, 0x1522, 0x108E, 0x7B19, 0x1 }, /* Sun Dual Port GbE PCIe 2.0 Low Profile Adapter, MMF */
 { 0x8086, 0x1522, 0x8086, 0x0003, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-F4 */
 { 0x8086, 0x1522, 0x8086, 0x0004, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-F2 */
 { 0x8086, 0x1522, 0x8086, 0x0005, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-F1 */
 { 0x8086, 0x1522, 0x8086, 0x00A3, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-F4 */
 { 0x8086, 0x1522, 0x8086, 0x00A4, 0x1 }, /* Intel(R) Ethernet Server Adapter I350-F2 */
 { 0x8086, 0x1522, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I350 Gigabit Fiber Network Connection */
 { 0x8086, 0x1523, 0x1028, 0x0660, 0xF }, /* Intel(R) Gigabit 2P I350 LOM */
 { 0x8086, 0x1523, 0x1028, 0x1F9B, 0xF }, /* Intel(R) Gigabit 4P I350 bNDC */
 { 0x8086, 0x1523, 0x103C, 0x18D1, 0xF }, /* HP Ethernet 1Gb 2-port 361FLB Adapter */
 { 0x8086, 0x1523, 0x103C, 0x1989, 0xF }, /* HP Ethernet 1Gb 2-port 363i Adapter */
 { 0x8086, 0x1523, 0x103C, 0x339F, 0xF }, /* HP Ethernet 1Gb 4-port 366M Adapter */
 { 0x8086, 0x1523, 0x8086, 0x1F52, 0xF }, /* Intel(R) Gigabit 4P I350-t Mezz */
 { 0x8086, 0x1523, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I350 Gigabit Backplane Connection */
 { 0x8086, 0x1524, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I350 Gigabit Connection */
 { 0x8086, 0x1525, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82567V-4 Gigabit Network Connection */
 { 0x8086, 0x1526, 0x8086, 0xA05C, 0x1 }, /* Intel(R) Gigabit ET2 Quad Port Server Adapter */
 { 0x8086, 0x1526, 0x8086, 0xA06C, 0x1 }, /* Intel(R) Gigabit ET2 Quad Port Server Adapter */
 { 0x8086, 0x1527, 0x8086, 0x0001, 0x1 }, /* Intel(R) Ethernet Server Adapter I340-F4 */
 { 0x8086, 0x1527, 0x8086, 0x0002, 0x1 }, /* Intel(R) Ethernet Server Adapter I340-F4 */
 { 0x8086, 0x152D, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82576 Virtual Function */
 { 0x8086, 0x152F, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) I350 Virtual Function */
 { 0x8086, 0x1533, 0x103C, 0x0003, 0xF }, /* Intel(R) Ethernet I210-T1 GbE NIC */
 { 0x8086, 0x1533, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Server Adapter I210-T1 */
 { 0x8086, 0x1533, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Server Adapter I210-T1 */
 { 0x8086, 0x1533, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I210 Gigabit Network Connection */
 { 0x8086, 0x1536, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I210 Gigabit Fiber Network Connection */
 { 0x8086, 0x1537, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I210 Gigabit Backplane Connection */
 { 0x8086, 0x1538, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I210 Gigabit Network Connection */
 { 0x8086, 0x1539, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I211 Gigabit Network Connection */
 { 0x8086, 0x153A, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection I217-LM */
 { 0x8086, 0x153A, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection I217-LM */
 { 0x8086, 0x153A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I217-LM */
 { 0x8086, 0x153B, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection I217-V */
 { 0x8086, 0x153B, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection I217-V */
 { 0x8086, 0x153B, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I217-V */
 { 0x8086, 0x1559, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection I218-V */
 { 0x8086, 0x1559, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection I218-V */
 { 0x8086, 0x1559, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I218-V */
 { 0x8086, 0x155A, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection I218-LM */
 { 0x8086, 0x155A, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection I218-LM */
 { 0x8086, 0x155A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I218-LM */
 { 0x8086, 0x156F, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection I219-LM */
 { 0x8086, 0x156F, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection I219-LM */
 { 0x8086, 0x156F, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I219-LM */
 { 0x8086, 0x1570, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection I219-V */
 { 0x8086, 0x1570, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection I219-V */
 { 0x8086, 0x1570, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I219-V */
 { 0x8086, 0x157B, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I210 Gigabit Network Connection */
 { 0x8086, 0x157C, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) I210 Gigabit Backplane Connection */
 { 0x8086, 0x15A0, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection (2) I218-LM */
 { 0x8086, 0x15A0, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection (2) I218-LM */
 { 0x8086, 0x15A1, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection (2) I218-V */
 { 0x8086, 0x15A1, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection (2) I218-V */
 { 0x8086, 0x15A2, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection (3) I218-LM */
 { 0x8086, 0x15A2, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection (3) I218-LM */
 { 0x8086, 0x15A2, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection (3) I218-LM */
 { 0x8086, 0x15A3, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection (3) I218-V */
 { 0x8086, 0x15A3, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection (3) I218-V */
 { 0x8086, 0x15A3, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection (3) I218-V */
 { 0x8086, 0x15B7, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection (2) I219-LM */
 { 0x8086, 0x15B7, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection (2) I219-LM */
 { 0x8086, 0x15B7, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection (2) I219-LM */
 { 0x8086, 0x15B8, 0x1179, 0x0001, 0xF }, /* Intel(R) Ethernet Connection (2) I219-V */
 { 0x8086, 0x15B8, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Connection (2) I219-V */
 { 0x8086, 0x15B8, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection (2) I219-V */
 { 0x8086, 0x1F40, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I354 1.0 GbE Backplane */
 { 0x8086, 0x1F41, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I354 */
 { 0x8086, 0x1F45, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection I354 2.5 GbE Backplane */
 { 0x8086, 0x294C, 0x17AA, 0x302E, 0xF }, /* Intel(R) 82566DC-2 Gigabit Network Connection */
 { 0x8086, 0x294C, 0x8086, 0x294C, 0xF }, /* Intel(R) 82566DC-2 Gigabit Network Connection */
 { 0x8086, 0x294C, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82566DC-2 Gigabit Network Connection */
#endif /* WOL_1G */

#if defined(WOL_10G)
 { 0x8086, 0x10A6, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB Multi-Function Network Device */
 { 0x8086, 0x10B6, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit KX4 Network Connection */
 { 0x8086, 0x10C6, 0x8086, 0xA05F, 0x0 }, /* Intel(R) 10 Gigabit XF SR Dual Port Server Adapter */
 { 0x8086, 0x10C6, 0x8086, 0xA15F, 0x0 }, /* Intel(R) 10 Gigabit XF SR Dual Port Server Adapter */
 { 0x8086, 0x10C6, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit AF Dual Port Network Connection */
 { 0x8086, 0x10C7, 0x8086, 0xA05F, 0x0 }, /* Intel(R) 10 Gigabit XF SR Server Adapter */
 { 0x8086, 0x10C7, 0x8086, 0xA15F, 0x0 }, /* Intel(R) 10 Gigabit XF SR Server Adapter */
 { 0x8086, 0x10C7, 0x8086, 0xA16F, 0x0 }, /* Intel(R) 10 Gigabit XF SR Server Adapter */
 { 0x8086, 0x10C7, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit AF Network Connection */
 { 0x8086, 0x10C8, 0x8086, 0xA10C, 0x0 }, /* Intel(R) 10 Gigabit AT Server Adapter */
 { 0x8086, 0x10C8, 0x8086, 0xA11C, 0x0 }, /* Intel(R) 10 Gigabit AT Server Adapter */
 { 0x8086, 0x10C8, 0x8086, 0xA12C, 0x0 }, /* Intel(R) 10 Gigabit AT Server Adapter */
 { 0x8086, 0x10C8, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit AT Network Connection */
 { 0x8086, 0x10DB, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10DD, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit AT CX4 Network Connection */
 { 0x8086, 0x10E1, 0x108E, 0xB25F, 0x0 }, /* Intel(R) 10 Gigabit SR Dual Port Express Module */
 { 0x8086, 0x10E1, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 10 Gigabit SR Dual Port Express Module */
 { 0x8086, 0x10EC, 0x8086, 0xA01F, 0x0 }, /* Intel(R) 10 Gigabit CX4 Dual Port Server Adapter */
 { 0x8086, 0x10EC, 0x8086, 0xA11F, 0x0 }, /* Intel(R) 10 Gigabit CX4 Dual Port Server Adapter */
 { 0x8086, 0x10EC, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 10 Gigabit CX4 Dual Port Server Adapter */
 { 0x8086, 0x10ED, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 Virtual Function */
 { 0x8086, 0x10F1, 0x8086, 0xA20F, 0x0 }, /* Intel(R) 10 Gigabit AF DA Dual Port Server Adapter */
 { 0x8086, 0x10F1, 0x8086, 0xA21F, 0x0 }, /* Intel(R) 10 Gigabit AF DA Dual Port Server Adapter */
 { 0x8086, 0x10F1, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 10 Gigabit AF DA Dual Port Server Adapter */
 { 0x8086, 0x10F4, 0x8086, 0xA06F, 0x0 }, /* Intel(R) 10 Gigabit XF LR Server Adapter */
 { 0x8086, 0x10F4, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit AF Network Connection */
 { 0x8086, 0x10F7, 0x108E, 0x7B12, 0x0 }, /* Sun Dual 10GbE PCIe 2.0 FEM */
 { 0x8086, 0x10F7, 0x8086, 0x000D, 0xF }, /* Intel(R) Ethernet Mezzanine Adapter X520-KX4-2 */
 { 0x8086, 0x10F7, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 10 Gigabit BR KX4 Dual Port Network Connection */
 { 0x8086, 0x10F8, 0x1028, 0x1F63, 0xF }, /* Intel(R) Ethernet 10G 2P X520-k bNDC */
 { 0x8086, 0x10F8, 0x103C, 0x17D2, 0xF }, /* HP Ethernet 10Gb 2-port 560M Adapter */
 { 0x8086, 0x10F8, 0x103C, 0x18D0, 0xF }, /* HP Ethernet 10Gb 2-port 560FLB Adapter */
 { 0x8086, 0x10F8, 0x8086, 0x000C, 0x0 }, /* Intel(R) Ethernet X520 10GbE Dual Port KX4-KR Mezz */
 { 0x8086, 0x10F8, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82599 10 Gigabit Dual Port Backplane Connection */
 { 0x8086, 0x10F9, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 10 Gigabit CX4 Dual Port Network Connection */
 { 0x8086, 0x10FB, 0x1028, 0x06EE, 0xF }, /* Intel(R) Ethernet 10G X520 LOM */
 { 0x8086, 0x10FB, 0x1028, 0x1F72, 0xF }, /* Intel(R) Ethernet 10G 4P X520/I350 rNDC */
 { 0x8086, 0x10FB, 0x103C, 0x17D0, 0x1 }, /* HP Ethernet 10Gb 2-port 560FLR-SFP+ Adapter */
 { 0x8086, 0x10FB, 0x103C, 0x17D3, 0x0 }, /* HP Ethernet 10Gb 2-port 560SFP+ Adapter */
 { 0x8086, 0x10FB, 0x103C, 0x211B, 0xF }, /* HP Ethernet 10Gb 1-port P560FLR-SFP+ Adapter */
 { 0x8086, 0x10FB, 0x103C, 0x2159, 0x1 }, /* HP Ethernet 10Gb 2-port 562i Adapter */
 { 0x8086, 0x10FB, 0x108E, 0x7B11, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-2 */
 { 0x8086, 0x10FB, 0x152D, 0x8975, 0x0 }, /* Intel(R) 82599 10 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10FB, 0x1734, 0x11A9, 0x1 }, /* Intel(R) 82599 10 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10FB, 0x17AA, 0x1071, 0x1 }, /* Lenovo ThinkServer X520-2 AnyFabric */
 { 0x8086, 0x10FB, 0x8086, 0x0002, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-DA2 */
 { 0x8086, 0x10FB, 0x8086, 0x0003, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-2 */
 { 0x8086, 0x10FB, 0x8086, 0x0006, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-1 */
 { 0x8086, 0x10FB, 0x8086, 0x0008, 0x1 }, /* Intel(R) Ethernet OCP Server Adapter X520-2 */
 { 0x8086, 0x10FB, 0x8086, 0x000A, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-1 */
 { 0x8086, 0x10FB, 0x8086, 0x000C, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-2 */
 { 0x8086, 0x10FB, 0x8086, 0x0470, 0xF }, /* Intel(R) Ethernet 10GSFP+ DP Embedded CNA X520-2 */
 { 0x8086, 0x10FB, 0x8086, 0x7A11, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-2 */
 { 0x8086, 0x10FB, 0x8086, 0x7A12, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-2 */
 { 0x8086, 0x10FB, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 10 Gigabit Dual Port Network Connection */
 { 0x8086, 0x10FC, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 10 Gigabit Dual Port Network Connection */
 { 0x8086, 0x1507, 0x108E, 0x7B10, 0x0 }, /* Intel(R) Ethernet ExpressModule X520-P2 */
 { 0x8086, 0x150B, 0x8086, 0xA10C, 0x0 }, /* Intel(R) 10 Gigabit AT2 Server Adapter */
 { 0x8086, 0x150B, 0x8086, 0xA11C, 0x0 }, /* Intel(R) 10 Gigabit AT2 Server Adapter */
 { 0x8086, 0x150B, 0x8086, 0xA12C, 0x0 }, /* Intel(R) 10 Gigabit AT2 Server Adapter */
 { 0x8086, 0x150B, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82598EB 10 Gigabit AT2 Network Connection */
 { 0x8086, 0x1514, 0x8086, 0x000B, 0x0 }, /* Intel(R) Ethernet X520 10GbE Dual Port KX4 Mezz */
 { 0x8086, 0x1515, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X540 Virtual Function */
 { 0x8086, 0x1517, 0x1137, 0x006A, 0x0 }, /* Cisco UCS CNA M61KR-I Intel Converged Network Adapter */
 { 0x8086, 0x151C, 0x108E, 0x7B13, 0x0 }, /* Sun Dual 10GBASE-T LP */
 { 0x8086, 0x151C, 0x8086, 0xA02C, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-T2 */
 { 0x8086, 0x151C, 0x8086, 0xA03C, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-T2 */
 { 0x8086, 0x151C, 0x8086, 0xA21C, 0x0 }, /* Intel(R) Ethernet Server Adapter X520-T2 */
 { 0x8086, 0x151C, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 10 Gigabit TN Network Connection */
 { 0x8086, 0x1528, 0x1028, 0x1F61, 0xF }, /* Intel(R) Ethernet 10G 4P X540/I350 rNDC */
 { 0x8086, 0x1528, 0x103C, 0x192D, 0x1 }, /* HP Ethernet 10Gb 2-port 561FLR-T Adapter */
 { 0x8086, 0x1528, 0x103C, 0x211A, 0x0 }, /* HP Ethernet 10Gb 2-port 561T Adapter */
 { 0x8086, 0x1528, 0x108E, 0x7B14, 0x0 }, /* Sun Dual Port 10 GbE PCIe 2.0 ExpressModule, Base-T */
 { 0x8086, 0x1528, 0x108E, 0x7B15, 0x0 }, /* Sun Dual Port 10 GbE PCIe 2.0 Low Profile Adapter, Base-T */
 { 0x8086, 0x1528, 0x1137, 0x00BF, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X540-T2 */
 { 0x8086, 0x1528, 0x1137, 0x00D4, 0x0 }, /* Cisco X540-TX 10 Gig LOM */
 { 0x8086, 0x1528, 0x17AA, 0x1073, 0xF }, /* Lenovo ThinkServer X540-T2 AnyFabric */
 { 0x8086, 0x1528, 0x8086, 0x0001, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X540-T2 */
 { 0x8086, 0x1528, 0x8086, 0x0002, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X540-T1 */
 { 0x8086, 0x1528, 0x8086, 0x001A, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X540-T2 */
 { 0x8086, 0x1528, 0x8086, 0x00A2, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X540-T1 */
 { 0x8086, 0x1528, 0x8086, 0x0471, 0xF }, /* Intel(R) Ethernet 10GBT DP Embedded CNA X540-T2 */
 { 0x8086, 0x1528, 0x8086, 0x5003, 0x0 }, /* Intel(R) Ethernet 10G 2P X540-t Adapter */
 { 0x8086, 0x1528, 0x8086, 0x5004, 0x0 }, /* Intel(R) Ethernet 10G 2P X540-t Adapter */
 { 0x8086, 0x1528, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X540-AT2 */
 { 0x8086, 0x1529, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 10 Gigabit Dual Port Network Connection with FCoE */
 { 0x8086, 0x152A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) 82599 10 Gigabit Dual Port Backplane Connection with FCoE */
 { 0x8086, 0x152E, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 Virtual Function */
 { 0x8086, 0x1530, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X540 Virtual Function */
 { 0x8086, 0x154A, 0x8086, 0x011A, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X520-4 */
 { 0x8086, 0x154A, 0x8086, 0x011B, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X520-4 */
 { 0x8086, 0x154A, 0x8086, 0x011C, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X520-4 */
 { 0x8086, 0x154D, 0x8086, 0x7B11, 0x0 }, /* Intel(R) Ethernet 10G 2P X520 Adapter */
 { 0x8086, 0x1557, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet OCP Server Adapter X520-1 */
 { 0x8086, 0x1557, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) 82599 10 Gigabit Network Connection */
 { 0x8086, 0x1558, 0x8086, 0x011A, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X520-Q1 */
 { 0x8086, 0x1558, 0x8086, 0x011B, 0x0 }, /* Intel(R) Ethernet Converged Network Adapter X520-Q1 */
 { 0x8086, 0x1560, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X540 */
 { 0x8086, 0x1563, 0x1590, 0x001D, 0x0 }, /* HPE Ethernet 10Gb 2-port 562T Adapter */
 { 0x8086, 0x1563, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X550-T2 */
 { 0x8086, 0x1563, 0x8086, 0x001A, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X550-T2 */
 { 0x8086, 0x1563, 0x8086, 0x001D, 0x0 }, /* Intel(R) Ethernet 10G 2P X550-t Adapter */
 { 0x8086, 0x1563, 0x8086, 0x0022, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X550-T2 */
 { 0x8086, 0x1563, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X550 */
 { 0x8086, 0x1564, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X550 Virtual Function */
 { 0x8086, 0x1565, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X550 Virtual Function */
 { 0x8086, 0x15A8, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X552 Virtual Function */
 { 0x8086, 0x15A9, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X552 Virtual Function */
 { 0x8086, 0x15AA, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X552 10 GbE Backplane */
 { 0x8086, 0x15AB, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X552 10 GbE Backplane */
 { 0x8086, 0x15AC, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X552 10 GbE SFP+ */
 { 0x8086, 0x15AD, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X552/X557-AT 10GBASE-T */
 { 0x8086, 0x15C2, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 10 GbE Backplane */
 { 0x8086, 0x15C3, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 1 GbE Backplane */
 { 0x8086, 0x15C4, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 10 GbE SFP+ */
 { 0x8086, 0x15C6, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 1GbE */
 { 0x8086, 0x15C7, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 1GbE */
 { 0x8086, 0x15C8, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553/X557-AT 10GBASE-T */
 { 0x8086, 0x15CA, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 QSFP+ */
 { 0x8086, 0x15CC, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X553 QSFP+ */
 { 0x8086, 0x15D1, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X550-T1 */
 { 0x8086, 0x15D1, 0x8086, 0x0021, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X550-T1 */
 { 0x8086, 0x15D1, 0x8086, 0x00A2, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X550-T1 */
 { 0x8086, 0x15D1, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X550 */
#endif /* WOL_10G */

#if defined(WOL_40G)
 { 0x8086, 0x154C, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) XL710/X710 Virtual Function */
 { 0x8086, 0x1571, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) XL710/X710 Virtual Function */
 { 0x8086, 0x1572, 0x1028, 0x0000, 0xF }, /* Intel(R) Ethernet 10G X710 rNDC */
 { 0x8086, 0x1572, 0x1028, 0x1F99, 0xF }, /* Intel(R) Ethernet 10G 4P X710/I350 rNDC */
 { 0x8086, 0x1572, 0x1028, 0x1F9C, 0xF }, /* Intel(R) Ethernet 10G 4P X710 SFP+ rNDC */
 { 0x8086, 0x1572, 0x103C, 0x0000, 0xF }, /* HPE Ethernet 10Gb 562SFP+ Adapter */
 { 0x8086, 0x1572, 0x103C, 0x22FC, 0xF }, /* HPE Ethernet 10Gb 2-port 562FLR-SFP+ Adapter */
 { 0x8086, 0x1572, 0x103C, 0x22FD, 0xF }, /* HPE Ethernet 10Gb 2-port 562SFP+ Adapter */
 { 0x8086, 0x1572, 0x1137, 0x0000, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-4 */
 { 0x8086, 0x1572, 0x1137, 0x013B, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-4 */
 { 0x8086, 0x1572, 0x17AA, 0x0000, 0xF }, /* Lenovo ThinkServer X710 AnyFabric for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x17AA, 0x4001, 0xF }, /* Lenovo ThinkServer X710-4 AnyFabric for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x17AA, 0x4002, 0xF }, /* Lenovo ThinkServer X710-2 AnyFabric for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710 */
 { 0x8086, 0x1572, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-4 */
 { 0x8086, 0x1572, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-4 */
 { 0x8086, 0x1572, 0x8086, 0x0004, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-4 */
 { 0x8086, 0x1572, 0x8086, 0x0005, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710 */
 { 0x8086, 0x1572, 0x8086, 0x0006, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710 */
 { 0x8086, 0x1572, 0x8086, 0x0007, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-2 */
 { 0x8086, 0x1572, 0x8086, 0x0008, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-2 */
 { 0x8086, 0x1572, 0x8086, 0x0009, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x000A, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x000D, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x4005, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x4006, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1580, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 40GbE backplane */
 { 0x8086, 0x1581, 0x1028, 0x0000, 0xF }, /* Intel(R) Ethernet 10G X710-k bNDC */
 { 0x8086, 0x1581, 0x1028, 0x1F98, 0xF }, /* Intel(R) Ethernet 10G 4P X710-k bNDC */
 { 0x8086, 0x1581, 0x1028, 0x1F9E, 0xF }, /* Intel(R) Ethernet 10G 2P X710-k bNDC */
 { 0x8086, 0x1581, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE backplane */
 { 0x8086, 0x1583, 0x1028, 0x0000, 0xF }, /* Intel(R) Ethernet 40G 2P XL710 QSFP+ rNDC */
 { 0x8086, 0x1583, 0x1028, 0x1F9F, 0xF }, /* Intel(R) Ethernet 40G 2P XL710 QSFP+ rNDC */
 { 0x8086, 0x1583, 0x108E, 0x0000, 0xF }, /* Oracle Quad 10Gb Ethernet Adapter */
 { 0x8086, 0x1583, 0x108E, 0x7B1B, 0xF }, /* Oracle Quad 10Gb Ethernet Adapter */
 { 0x8086, 0x1583, 0x1137, 0x0000, 0xF }, /* Cisco(R) Ethernet Converged NIC XL710-Q2 */
 { 0x8086, 0x1583, 0x1137, 0x013C, 0xF }, /* Cisco(R) Ethernet Converged NIC XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet I/O Module XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0006, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 40GbE QSFP+ */
 { 0x8086, 0x1584, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q1 */
 { 0x8086, 0x1584, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q1 */
 { 0x8086, 0x1584, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q1 */
 { 0x8086, 0x1584, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet I/O Module XL710-Q1 */
 { 0x8086, 0x1584, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 40GbE QSFP+ */
 { 0x8086, 0x1585, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 10GbE QSFP+ */
 { 0x8086, 0x1586, 0x108E, 0x0000, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x1586, 0x108E, 0x4857, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x1586, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x1587, 0x103C, 0x0000, 0xF }, /* HPE Flex-20 20Gb 2-port 660FLB Adapter */
 { 0x8086, 0x1587, 0x103C, 0x22FE, 0xF }, /* HPE Flex-20 20Gb 2-port 660FLB Adapter */
 { 0x8086, 0x1588, 0x103C, 0x0000, 0xF }, /* HPE Flex-20 20Gb 2-port 660M Adapter */
 { 0x8086, 0x1588, 0x103C, 0x22FF, 0xF }, /* HPE Flex-20 20Gb 2-port 660M Adapter */
 { 0x8086, 0x1589, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T */
 { 0x8086, 0x1589, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T4 */
 { 0x8086, 0x1589, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T4 */
 { 0x8086, 0x1589, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710/X557-AT 10GBASE-T */
 { 0x8086, 0x374C, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Fort Park Ethernet Controller */
 { 0x8086, 0x374D, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Fort Park Virtual Function */
 { 0x8086, 0x3759, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Fort Park Virtual Function */
 { 0x8086, 0x37CC, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Fort Park Ethernet Controller */
 { 0x8086, 0x37CD, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Fort Park Virtual Function */
 { 0x8086, 0x37D0, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Fort Park Ethernet Controller */
 { 0x8086, 0x37D1, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Fort Park Ethernet Controller */
 { 0x8086, 0x37D2, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Fort Park Ethernet Controller */
 { 0x8086, 0x37D9, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Fort Park Virtual Function */
 { 0x8086, 0xF0A2, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Fort Park Ethernet Controller FPGA */
 { 0x8086, 0xF0A3, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Fort Park FPGA Virtual Function */
 { 0x8086, 0xF0A4, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Fort Park FPGA Virtual Function */
#endif /* WOL_40G */

 {      0,      0,      0,      0,   0 }  /* Last entry */
};

