/**************************************************************************

Copyright (c) 2016, Intel Corporation

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/


#ifndef I40E_OSDEP_H_
#define I40E_OSDEP_H_

#include <Uefi.h>
#include <Base.h>
#include <Library\BaseLib.h>
#include <Library\BaseMemoryLib.h>
#include <Library\SynchronizationLib.h>
#include <Library\UefiLib.h>
#include <Library/PrintLib.h>

// Remove "conversion from ... to ..., possible lost of data" warning
#pragma warning(disable : 4244)

// Remove "Type cast from data pointer to function pointer" warning
#pragma warning(disable : 4055)


#ifdef EFI32

// Remove truncation warning in type cast when some 64 bit variables are converted to 32-bit pointers
#pragma warning(disable : 4305)
#endif /* EFI32 */

#define CHAR        CHAR8
#define memcmp      CompareMem
#define memcpy      CopyMem
#define strlen      AsciiStrLen

#define int32_t  INT32
#define uint32_t UINT32
#define int16_t  INT16
#define uint16_t UINT16

#define size_t UINTN

typedef UINT64  __le64;
typedef UINT64  u64;
typedef INT64   s64;
typedef UINT32  __le32;
typedef UINT32  u32;
typedef INT32   s32;
typedef UINT16  __le16;
typedef UINT16  u16;
typedef INT16   s16;
typedef UINT8   u8;
typedef INT8    s8;

typedef BOOLEAN bool;

#define false FALSE
#define true  TRUE

#define INLINE

// temporarily redefine inline keyword until the shared code fix is in place
#define inline

// Some macros necessary for the C Shared Code to compile correctly
#define sprintf(a, b, c) AsciiSPrint((a), sizeof(a), (b), (c))
#define ARRAY_SIZE(a) (sizeof(a) / sizeof((a)[0]))

#if 0
#undef ASSERT
#define ASSERT(x)
#define DEBUGOUT  AsciiPrint
#define DEBUGOUT1 AsciiPrint
#define DEBUGOUT2 AsciiPrint
#define DEBUGOUT3 AsciiPrint
#define DEBUGOUT4 AsciiPrint
#define DEBUGOUT6 AsciiPrint
#define DEBUGOUT7 AsciiPrint
#else /* 1 */
#undef ASSERT
#define ASSERT(x)
#define DEBUGOUT(s)
#define DEBUGOUT1(s, a)
#define DEBUGOUT2(s, a, b)
#define DEBUGOUT3(s, a, b, c)
#define DEBUGOUT6(s, a, b, c, d, e, f)
#define DEBUGOUT7(s, a, b, c, d, e, f, g)
#endif /* 0 */

#define DEBUGFUNC(F)                        DEBUGOUT (F)

#define CPU_TO_LE16(o) ((u16)(o))
#define CPU_TO_LE32(s) ((u32)(s))
#define CPU_TO_LE64(h) ((u64)(h))
#define LE16_TO_CPU(a) ((u16)(a))
#define LE32_TO_CPU(c) ((u32)(c))
#define LE64_TO_CPU(k) ((u64)(k))

/* Data type manipulation macros. */
#define HIDWORD(x) ((UINT32)(((x)>>32)&0xFFFFFFFF))
#define LODWORD(x) ((UINT32)((x)&0xFFFFFFFF))

#define HIWORD(x) ((UINT16)(((x)>>16)&0xFFFF))
#define LOWORD(x) ((UINT16)((x)&0xFFFF))

#define HIBYTE(x) ((UINT8)(((x)>>8)&0xFF))
#define LOBYTE(x) ((UINT8)((x)&0xFF))

#define LOW_BYTE(word)      LOBYTE(word)
#define HIGH_BYTE(word)     HIBYTE(word)

#define LOW_WORD(dword)     LOWORD(dword)
#define HIGH_WORD(dword)    HIWORD(dword)

#define MAKE_WORD(hi, low)                  \
          ((UINT16) ((((UINT16)(hi)) << 8) | (low)))

struct i40e_dma_mem {
    VOID   *va;
    UINT64 pa;
    UINT32 size;
};

#define i40e_allocate_dma_mem(h, m, unused, s, a) I40eAllocateDmaMem(h, m, s, a)
#define i40e_free_dma_mem(h, m) I40eFreeDmaMem(h, m)

struct i40e_virt_mem {
    VOID   *va;
    UINT32 size;
};

#define i40e_allocate_virt_mem(h, m, s) I40eAllocateMem(h, m, s)
#define i40e_free_virt_mem(h, m) I40eFreeMem(h, m)


struct i40e_spinlock {
    SPIN_LOCK SpinLock;
};

#define i40e_init_spinlock(sp) I40eInitSpinLock(sp)
#define i40e_acquire_spinlock(sp) I40eAcquireSpinLock(sp)
#define i40e_release_spinlock(sp) I40eReleaseSpinLock(sp)
#define i40e_destroy_spinlock(sp) I40eDestroySpinLock(sp)

typedef struct DRIVER_DATA_S  I40E_DRIVER_DATA;

/** This function calls the MemIo callback to read a dword from the device's
   address space

   @param[in]   AdapterInfo   Pointer to the NIC data structure information
                             the UNDI driver is layering on
   @param[in]   Port         Address to read from

   @return      The data read from the port.
**/
UINT32
I40eRead32(
  IN I40E_DRIVER_DATA *AdapterInfo,
  IN UINT32           Port
  );

/** This function calls the MemIo callback to write a word from the device's
   address space

   @param[in]   AdapterInfo   Pointer to the NIC data structure information
                             the UNDI driver is layering on
   @param[in]   Port         Address to write to
   @param[in]   Data         Data to write to Port

   @return    Data written to address in device's space
**/
VOID
I40eWrite32(
  IN I40E_DRIVER_DATA *AdapterInfo,
  IN UINT32           Port,
  IN UINT32           Data
  );

/** Delays execution of next instructions for MicroSeconds microseconds

   @param[in]   AdapterInfo   Pointer to the NIC data structure information
                             the UNDI driver is layering on
   @param[in]   MicroSeconds   Time to delay in Microseconds.

   @retval   NONE
**/
VOID
DelayInMicroseconds (
  IN I40E_DRIVER_DATA  *AdapterInfo,
  UINT32               MicroSeconds
  );

#define wr32(a, reg, value) I40eWrite32 ((I40E_DRIVER_DATA *) ((a)->back), reg, value)
#define rd32(a, reg)        I40eRead32 ((I40E_DRIVER_DATA *) ((a)->back), (UINT32) (reg))

#define i40e_usec_delay(x) DelayInMicroseconds ((I40E_DRIVER_DATA *) (hw->back), x)
#define i40e_msec_delay(x) DelayInMicroseconds ((I40E_DRIVER_DATA *) (hw->back), x * 1000)

#define i40e_memset(a,b,c,d)  SetMem((a),(c),(b))
#define i40e_memcpy(a,b,c,d)  CopyMem((a),(b),(c)) 

#define memset(Buffer, Value, BufferLength) SetMem (Buffer, BufferLength, Value)

#define min(a,b) MIN(a,b)
#define max(a,b) MAX(a,b)

#define i40e_debug



//#define offsetof(type, member) ( (u16) & (((type*)0) -> member ))
#define offsetof(st, m) \
          ((size_t) ( (char *)&((st *)(0))->m - (char *)0 ))

#define FIELD_SIZEOF(t, f) (sizeof(((t*)0)->f))


#endif /* I40E_OSDEP_H_ */
