/******************************************************************************
 * INTEL CONFIDENTIAL                                                         *
 * Copyright 2014-2016 Intel Corporation All Rights Reserved.                 *
 *                                                                            *
 * The source code contained or described herein and all documents related    *
 * to the source code ("Material") are owned by Intel Corporation or          *
 * its suppliers or licensors. Title to the Material remains                  *
 * with Intel Corporation or its suppliers and licensors.                     *
 * The Material contains trade secrets and proprietary and confidential       *
 * information of Intel or its suppliers and licensors.                       *
 * The Material is protected by worldwide copyright and trade secret laws     *
 * and treaty provisions. No part of the Material may be used, copied,        *
 * reproduced, modified, published, uploaded, posted, transmitted,            *
 * distributed, or disclosed in any way without Intel's                       *
 * prior express written permission.                                          *
 *                                                                            *
 * No license under any patent, copyright, trade secret or other              *
 * intellectual property right is granted to or conferred upon you            *
 * by disclosure or delivery of the Materials, either expressly,              *
 * by implication, inducement, estoppel or otherwise.                         *
 * Any license under such intellectual property rights                        *
 * must be express and approved by Intel in writing.                          *
 ******************************************************************************/
#include <wol.h>

#define FVL_SOFTWARE_RESERVED_WORD_2      0x0019
#define FVL_AUTOGEN_PTR_PFPM_APM_SECTION  0x1
#define FVL_AUTOGEN_PTR_PFPM_APM_OFFSET   0x2

static UINT16 _WolGetFVLRegisterInitializationDataOffset(
  IN  WOL_ADAPTER_HANDLE_TYPE Handle,
  IN  UINT16                  ModulePointer,
  IN  UINT32                  AutoGenPtrAddress
) {
  UINT16     ModuleOffset;
  UINT16     OffsetWithinModule;
  UINT16     AutoGeneratedSectionPointer;
  WOL_STATUS Status = WOL_SUCCESS;

  /* Read pointer to the auto generated pointers section */
  Status = _WolEepromRead16(
             Handle,
             I40E_SR_AUTO_GENERATED_POINTERS_PTR,
             &AutoGeneratedSectionPointer
             );
  if (Status != WOL_SUCCESS)
  {
    return 0;
  }
  
  /* Read Nvm Module offset in SR */
  Status = _WolEepromRead16(
             Handle,
             AutoGeneratedSectionPointer + ModulePointer,
             &ModuleOffset
             );
  if (Status != WOL_SUCCESS)
  {
    return 0;
  }

  /* Read the length of the module */
  Status = _WolEepromRead16 (
             Handle,
             AutoGeneratedSectionPointer + AutoGenPtrAddress,
             &OffsetWithinModule
             );
  if (Status != WOL_SUCCESS)
  {
    return 0;
  }

  if ((ModuleOffset == 0x7FFF) || (ModuleOffset == 0xFFFF))
  {
    return 0;
  }

  if (OffsetWithinModule == 0x0000)
  {
    return 0;
  }

  return ModuleOffset + OffsetWithinModule;

}

WOL_STATUS
_WolGetOffsetBitmask_40GBE (
  IN    WOL_ADAPTER_HANDLE_TYPE  Handle,
  OUT   UINT16                   *Offset,
  OUT   UINT16                   *Bitmask
)
{

  UINT8 FunctionNumber;

  if (Handle == NULL)
  {
    return WOL_FEATURE_NOT_SUPPORTED;
  }

  FunctionNumber = _WolGetFunction(Handle);

  if (FunctionNumber > 15)
  {
    return WOL_FEATURE_NOT_SUPPORTED;
  }

  /* EEPROM Control Word 3 */
  *Offset = _WolGetFVLRegisterInitializationDataOffset(
                                      Handle,
                                      FVL_AUTOGEN_PTR_PFPM_APM_SECTION,
                                      FVL_AUTOGEN_PTR_PFPM_APM_OFFSET);

  if (*Offset == 0)
  {
    return WOL_FEATURE_NOT_SUPPORTED;
  }

  /* return offset based on _PF */
  /* skip attributes word and get offset for PF */
  *Offset = *Offset + 2 * FunctionNumber;

  /* APM Enable Port 0     */
  *Bitmask = 0x0001;

  return WOL_SUCCESS;
}

BOOLEAN _WolGetInfoFromEeprom_40G(WOL_ADAPTER_HANDLE_TYPE Handle)
{
  UINT16      WolSupportMask;
  WOL_STATUS  Status;
  UINT8       LanPort;
  UINT8       WolSupport;

  /* DCR 1607 */
  Status = _WolEepromRead16(Handle,
                            FVL_SOFTWARE_RESERVED_WORD_2,
                            &WolSupportMask);

  if (Status != WOL_SUCCESS)
  {
    return FALSE;
  }
  else
  {
    LanPort = _WolGetLanPort(Handle);

    /* WolSupportMask: 1b = unsupported, 0b = supported */
    WolSupport = ((~WolSupportMask) & (1 << LanPort));

    return (BOOLEAN)WolSupport;
  }
}

