/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsdnalioctl.h                                                                                    *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsdnalioctl.h                                                                 *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef SDK_NAL_INC_FREEBSD_FREEBSDNALIOCTL_H_
#define SDK_NAL_INC_FREEBSD_FREEBSDNALIOCTL_H_

#include <sys/ioccom.h>

#define FREEBSD_DRIVER_VERSION                  ""
#define FREEBSD_DRIVER_MAJOR_VERSION                1

#define FREEBSD_DRIVER_MINOR_VERSION                1

#define FREEBSD_DRIVER_BUILD_VERSION                0

#define FREEBSD_DRIVER_FIX_VERSION                  1


/*
 * The group number of ioctl nal commands. It can be any value stored on 8 bits.
 */
#define FREEBSD_IOCTL_GROUP_NUMBER                  0x80

/*
 *  The macro for definitions of NAL IOCTL commands.
 */
#define NAL_MAKE_IOCTL( IoCtlNumber )               _IOWR( FREEBSD_IOCTL_GROUP_NUMBER , IoCtlNumber , NAL_IOCTL_INPUT_DATA )

#endif /* SDK_NAL_INC_FREEBSD_FREEBSDNALIOCTL_H_ */
