/**************************************************************************

Copyright (c) 2016, Intel Corporation

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/

#ifndef _IXGBE_OSDEP_H_
#define _IXGBE_OSDEP_H_

#pragma warning(disable : 4244)
#pragma warning(disable : 4206)
#pragma warning(disable : 4189)

#ifdef EFI32
//
// Remove truncation warning in type cast when some 64 bit variables are converted to 32-bit pointers
//
#pragma warning(disable : 4305)
#endif

#ifndef EFI_SPECIFICATION_VERSION
#define EFI_SPECIFICATION_VERSION 0x00020000
#endif

#ifndef TIANO_RELEASE_VERSION
#define TIANO_RELEASE_VERSION 0x00080005
#endif

#include <Uefi.h>
#include <Base.h>
#include <Library\BaseLib.h>
#include <Library\BaseMemoryLib.h>
#include <Library/PrintLib.h>

#define CHAR        CHAR8
#define memcmp      CompareMem
#define memcpy      CopyMem
#define strlen      AsciiStrLen

typedef UINT64  u64;
typedef INT64   s64;
typedef UINT32  u32;
typedef INT32   s32;
typedef UINT16  u16;
typedef INT16   s16;
typedef UINT8   u8;
typedef INT8    s8;
typedef BOOLEAN bool;

#define false FALSE
#define true  TRUE

typedef struct _DRIVER_DATA_  XGBE_DRIVER_DATA;

extern
VOID
DelayInMicroseconds (
  IN XGBE_DRIVER_DATA *GigAdapterInfo,
  UINT32              MicroSeconds
  );

extern
UINT32
XgbeInDword (
  XGBE_DRIVER_DATA *,
  UINT32
  );


extern
VOID
XgbeOutDword (
  XGBE_DRIVER_DATA *,
  UINT32 ,
  UINT32
  );


UINT16
XgbeReadPci16 (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT32           Offset
  );


VOID
XgbeWritePci16 (
  XGBE_DRIVER_DATA *XgbeAdapter,
  UINT32           Offset,
  UINT16           Data
  );


extern
VOID
XgbePciFlush (
  XGBE_DRIVER_DATA *
  );


UINT32
IxgbeHtonl (
  IN UINT32 Dword
  );

UINT16
IxgbeReverseWord (
  IN UINT16 Word
  );

UINT32
IxgbeReverseDword (
  IN UINT32 Dword
  );

#define usec_delay(x)                       DelayInMicroseconds ((XGBE_DRIVER_DATA *) (hw->back), x)
#define msec_delay(x)                       DelayInMicroseconds ((XGBE_DRIVER_DATA *) (hw->back), x * 1000)
#define memset(Buffer, Value, BufferLength) SetMem (Buffer, BufferLength, Value)

#define PCI_COMMAND_REGISTER                PCI_COMMAND_REGISTER_OFFSET
#define CMD_MEM_WRT_INVALIDATE              EFI_PCI_COMMAND_MEMORY_WRITE_AND_INVALIDATE

typedef BOOLEAN boolean_t;

#if 0
#undef ASSERT
#define ASSERT(x)
#define DEBUGOUT  Aprint
#define DEBUGOUT1 Aprint
#define DEBUGOUT2 Aprint
#define DEBUGOUT3 Aprint
#define DEBUGOUT6 Aprint
#define DEBUGOUT7 Aprint
#else
#undef ASSERT
#define ASSERT(x)
#define DEBUGOUT(s)
#define DEBUGOUT1(s, a)
#define DEBUGOUT2(s, a, b)
#define DEBUGOUT3(s, a, b, c)
#define DEBUGOUT6(s, a, b, c, d, e, f)
#define DEBUGOUT7(s, a, b, c, d, e, f, g)
#endif

#define EWARN(hw, s, remove_me_Im_only_the_workaround_for_SC_bug)

#define DEBUGFUNCXX AsciiPrint

#define DEBUGFUNC(F)                        DEBUGOUT (F)

#define IXGBE_WRITE_REG(a, reg, value)      XgbeOutDword ((XGBE_DRIVER_DATA *) ((a)->back), reg, value)

#define IXGBE_READ_REG(a, reg)              XgbeInDword ((XGBE_DRIVER_DATA *) ((a)->back), (UINT32) (reg))

#define IXGBE_WRITE_REG_ARRAY(a, reg, offset, value)  \
		XgbeOutDword ((XGBE_DRIVER_DATA *) ((a)->back), reg + ((offset) << 2), value)

#define IXGBE_READ_REG_ARRAY(a, reg, offset)  \
        XgbeInDword ((XGBE_DRIVER_DATA *) ((a)->back), reg + ((offset) << 2))

#define IXGBE_WRITE_FLUSH(a)                XgbePciFlush ((XGBE_DRIVER_DATA *) ((a)->back));

#define IXGBE_READ_PCIE_WORD(a, reg)        XgbeReadPci16 (a->back, reg)

#define IXGBE_WRITE_PCIE_WORD(a, reg, data) ; \
  XgbeWritePci16 (a->back, reg, data)

//#define IXGBE_HTONL(x)                      IxgbeHtonl (x)

#define IXGBE_NTOHS(_val) ((u16)(((u16)((_val) & 0xFF00) >> 8) | ((u16)((_val) & 0x00FF) << 8)))
#define IXGBE_NTOHL(_val) ( \
	(((u32)(_val)  & 0xFF000000) >> 24) | \
	 ((u32)((_val) & 0x00FF0000) >> 8)  | \
	 ((u32)((_val) & 0x0000FF00) << 8)  | \
	 ((u32)((_val) & 0x000000FF) << 24))
#define IXGBE_HTONL IXGBE_NTOHL

#define IXGBE_CPU_TO_LE32(s) ((UINT32)(s))
#define IXGBE_LE32_TO_CPU(c) ((UINT32)(c))
#define IXGBE_LE32_TO_CPUS(c) do {} while(0)

#define ERROR_REPORT(S,A)
#define ERROR_REPORT1(S,A)
#define ERROR_REPORT2(S,A,B)
#define ERROR_REPORT3(S,A,B,C)

#define IXGBE_CPU_TO_BE16(a) IxgbeReverseWord(a)
#define IXGBE_CPU_TO_BE32(a) IxgbeReverseDword(a)
#define IXGBE_BE32_TO_CPU(a) IxgbeReverseDword(a)
#define IXGBE_BE16_TO_CPU(a) IxgbeReverseWord(a)

#endif

