/******************************************************************************
 * INTEL CONFIDENTIAL                                                         *
 * Copyright 2014-2014 Intel Corporation All Rights Reserved.                 *
 *                                                                            *
 * The source code contained or described herein and all documents related    *
 * to the source code ("Material") are owned by Intel Corporation or          *
 * its suppliers or licensors. Title to the Material remains                  *
 * with Intel Corporation or its suppliers and licensors.                     *
 * The Material contains trade secrets and proprietary and confidential       *
 * information of Intel or its suppliers and licensors.                       *
 * The Material is protected by worldwide copyright and trade secret laws     *
 * and treaty provisions. No part of the Material may be used, copied,        *
 * reproduced, modified, published, uploaded, posted, transmitted,            *
 * distributed, or disclosed in any way without Intel's                       *
 * prior express written permission.                                          *
 *                                                                            *
 * No license under any patent, copyright, trade secret or other              *
 * intellectual property right is granted to or conferred upon you            *
 * by disclosure or delivery of the Materials, either expressly,              *
 * by implication, inducement, estoppel or otherwise.                         *
 * Any license under such intellectual property rights                        *
 * must be express and approved by Intel in writing.                          *
 ******************************************************************************/
#include <wol.h>

WOL_STATUS
_WolGetOffsetBitmask_CORDOVA (
  IN    WOL_ADAPTER_HANDLE_TYPE     Handle,
  OUT   UINT16                      *Offset,
  OUT   UINT16                      *Bitmask
  )
{
  UINT16  LanPort = 0;
  LanPort = _WolGetLanPort(Handle);

  if (LanPort == 0) {
    /* Initialization Control Word 2        */
    *Offset = 0x000F;
    /* APM Enable                           */
    *Bitmask = 0x0004;
    return WOL_SUCCESS;
  }
  return WOL_FEATURE_NOT_SUPPORTED;
}

WOL_STATUS
_WolGetOffsetBitmask_KENAI (
  IN    WOL_ADAPTER_HANDLE_TYPE     Handle,
  OUT   UINT16                      *Offset,
  OUT   UINT16                      *Bitmask
  )
{
  UINT16  LanPort = 0;
  LanPort = _WolGetLanPort(Handle);

  switch (LanPort)
  {
    case 0:
      /* Initialization Control 3 (port 0)  */
      *Offset = 0x0024;
      /* APM Enable                         */
      *Bitmask = 0x0400;
      return WOL_SUCCESS;
    case 1:
      /* Initialization Control 3 (port 1)  */
      *Offset = 0x0014;
      /* APM Enable                         */
      *Bitmask = 0x0400;
      return WOL_SUCCESS;
  }
  return WOL_FEATURE_NOT_SUPPORTED;
}

WOL_STATUS
_WolGetOffsetBitmask_NAHUM (
  IN    WOL_ADAPTER_HANDLE_TYPE     Handle,
  OUT   UINT16                      *Offset,
  OUT   UINT16                      *Bitmask
  )
{
  UINT16  LanPort = 0;
  LanPort = _WolGetLanPort(Handle);

  if (LanPort == 0) {
    *Offset = 0x000A;
    *Bitmask = 0x0004;
    return WOL_SUCCESS;
  }
  return WOL_FEATURE_NOT_SUPPORTED;
}

WOL_STATUS
_WolGetOffsetBitmask_NAHUM2 (
  IN    WOL_ADAPTER_HANDLE_TYPE     Handle,
  OUT   UINT16                      *Offset,
  OUT   UINT16                      *Bitmask
  )
{
  UINT16  LanPort = 0;
  LanPort = _WolGetLanPort(Handle);

  if (LanPort == 0) {
    *Offset = 0x001A;
    *Bitmask = 0x0001;
    return WOL_SUCCESS;
  }
  return WOL_FEATURE_NOT_SUPPORTED;
}

WOL_STATUS
_WolGetOffsetBitmask_BARTONHILLS (
  IN    WOL_ADAPTER_HANDLE_TYPE     Handle,
  OUT   UINT16                      *Offset,
  OUT   UINT16                      *Bitmask
  )
{
  UINT16  LanPort = 0;
  LanPort = _WolGetLanPort(Handle);

  /* Initialization Control 3   */
  /* plus offset for given port */
  switch (LanPort) {
    case 0:
      /* Initialization Control 3   */
      /* plus offset for given port */
      *Offset  = 0x0024 + 0x0000;
      /* APM Enable                 */
      *Bitmask = 0x0400;
      return WOL_SUCCESS;
    case 1:
      *Offset  = 0x0024 + 0x0080;
      *Bitmask = 0x0400;
      return WOL_SUCCESS;
    case 2:
      *Offset  = 0x0024 + 0x00C0;
      *Bitmask = 0x0400;
      return WOL_SUCCESS;
    case 3:
      *Offset  = 0x0024 + 0x0100;
      *Bitmask = 0x0400;
      return WOL_SUCCESS;
  }
  return WOL_FEATURE_NOT_SUPPORTED;
}

WOL_STATUS _WolEnableLaser(WOL_ADAPTER_HANDLE_TYPE Handle, BOOLEAN Enable)
{
  extern WOL_MAC_TYPE const WOL_LASER_TABLE[];
  if (_WolFindMacType(_WolGetMacType(Handle), (WOL_MAC_TYPE *)WOL_LASER_TABLE)) {
    WOL_STATUS Status;
    UINT16 Value = 0;
    if (!(E1000_HW_PTR(Handle)->phy.media_type == e1000_media_type_fiber)) {
      return WOL_FEATURE_NOT_SUPPORTED;
    }
    
    /* Read Software Defined Pins Control */
    Status = _WolEepromRead16(Handle, 0x20, &Value);
    if (Status != WOL_SUCCESS) {
      return Status;
    }

    /* Set/reset Software Defined Pin 7 to enable or disable the laser */
    if (Enable) {
      Value |= 0x0080;
    } else {
      Value &= ~0x0080;
    }

    /* Write Software Defined Pins Control back and update checksum */
    Status = _WolEepromWrite16(Handle, 0x20, Value);
    if (Status != WOL_SUCCESS) {
      return Status;
    }

    return _WolEepromUpdateChecksum(Handle);
  }

  return WOL_FEATURE_NOT_SUPPORTED;
}

