/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsdnaldriver.h                                                                                   *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsdnaldriver.h                                                                *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef SDK_NAL_INC_FREEBSD_FREEBSDNALDRIVER_H_
#define SDK_NAL_INC_FREEBSD_FREEBSDNALDRIVER_H_

#include <naltypes.h>
#include <freebsdos_i.h>
#include <sys/module.h>
#include <sys/conf.h>

typedef struct _NAL_ADAPTER_IN_USE_TABLE
{
    NAL_DEVICE_LOCATION DeviceLocation;
    BOOLEAN             InUse;
} NAL_ADAPTER_IN_USE_TABLE;

#define NAL_DRIVER_MAX_ADAPTERS 256

/***************************************************************************
 * Prototypes of functions, that handles KLD MODULES operations
 ***************************************************************************/

NAL_STATUS
_NalInitializeInterrupts(
    IN      NAL_FREEBSD_ISR_DEVICE*  NalIsrDevice
    );

NAL_STATUS
_NalUninitializeInterrupts(
    IN      NAL_FREEBSD_ISR_DEVICE*  NalIsrDevice
    );

BOOLEAN
_NalHasInterruptOccurred(
    IN      NAL_FREEBSD_ISR_DEVICE*  NalIsrDevice
    );

int
NalHandleModuleEvent (
                      IN      module_t    Module ,
                      IN      int         Event ,
                      IN OUT  void *      Argument );
int
NalOpenDriver(
              IN    struct cdev *   Device ,
              IN    int             OpenFlags ,
              IN    int             DeviceType ,
              IN    struct thread * Thread );
int
NalReleaseDriver(
                 IN     struct cdev *   Device ,
                 IN     int             ReleaseFlags  ,
                 IN     int             DeviceType ,
                 IN     struct thread * Thread );
int
NalHandleIoctl(
               IN      struct cdev *   Device ,
               IN      u_long          Command ,
               IN OUT  caddr_t         Data ,
               IN      int             Flags ,
               IN      struct thread * Thread );

VOID
_NalDriverDecrementReferenceCount(
    VOID
    );

VOID
_NalDriverIncrementReferenceCount(
    VOID
    );

UINT32
_NalDriverGetReferenceCount(
    VOID
    );


/*************************************************************************************************************
 * Declarations of global variables that are needed to handle FreeBSD driver
 ***************************************************************************/
extern struct cdevsw Global_NalDeviceEntryPoints;
extern struct cdev * Global_NalDevicePointer;

#endif /* SDK_NAL_INC_FREEBSD_FREEBSDNALDRIVER_H_ */
