ECHO ThinkHotkey installation >>C:\SWWORK\Modules.log

:: jGrimme 2015-10-15
:: kMcDaniel 2016-05-17
:: This script will extract and unzip cab files in a given folder into a different folder.
:: If calling from a module, please set the following variables:
 
:: Change directory to script location
pushd "%~dp0"

SET jg_path_to_plugins=.\
SET jg_path_to_log_file=.\install-baseutil.log
SET jg_path_to_install_plugins_dir=%ProgramData%\Lenovo\ImController\Plugins
SET jg_path_to_service="C:\Program Files\Lenovo\ImController\Service\Lenovo.Modern.ImController.exe"
 
:: Verify admin
NET SESSION >nul 2>&1
IF %ERRORLEVEL% NEQ 0 GOTO install_plugins_error_admin
 
echo installing plugins to ImController
echo installing plugins to ImController >> %jg_path_to_log_file%
echo jg_path_to_plugins: %jg_path_to_plugins% >> %jg_path_to_log_file%
echo jg_path_to_log_file: %jg_path_to_log_file% >> %jg_path_to_log_file%
echo jg_path_to_install_plugins_dir: %jg_path_to_install_plugins_dir% >> %jg_path_to_log_file%
echo jg_path_to_service: %jg_path_to_service% >> %jg_path_to_log_file%

echo "Deploying package"

goto Extract_Package_By_MySelf

:Extract_Package_By_IMC
rename %ProgramData%\Lenovo\ImController\ImControllerSubscription.xml ImControllerSubscription_.xml
copy ImControllerSubscription.xml %ProgramData%\Lenovo\ImController /Y

call %jg_path_to_service% /installpackages %jg_path_to_plugins%

del /Q %ProgramData%\Lenovo\ImController\ImControllerSubscription.xml
rename %ProgramData%\Lenovo\ImController\ImControllerSubscription_.xml ImControllerSubscription.xml
GOTO install_plugins_end


:Extract_Package_By_MySelf
:: This should not be necessary because these should not be running.  But just in case...
echo Disabling service
sc stop ImControllerService
taskkill /f /im Lenovo.Modern.ImController.exe
taskkill /f /im Lenovo.Modern.ImController.PluginHost.exe

:install_plugins_do_install
md "%jg_path_to_install_plugins_dir%"
FOR /R %jg_path_to_plugins% %%A IN (*.cab) DO (
echo Extracting plugin %%~nA
echo Extracting plugin %%~nA >> %jg_path_to_log_file%
if exist "%jg_path_to_install_plugins_dir%\%%~nA" rd /S /Q "%jg_path_to_install_plugins_dir%\%%~nA"  >> %jg_path_to_log_file%
if exist "%jg_path_to_install_plugins_dir%\%%~nA_" rd /S /Q "%jg_path_to_install_plugins_dir%\%%~nA_"  >> %jg_path_to_log_file%
md "%jg_path_to_install_plugins_dir%\%%~nA_"   >> %jg_path_to_log_file%
expand "%%A" /F:* "%jg_path_to_install_plugins_dir%\%%~nA_"   >> %jg_path_to_log_file%
 )
:: Granting correct plugin folder permissions because expand changes them
"%windir%\system32\icacls.exe" "%jg_path_to_install_plugins_dir%" /grant:r Users:RX Administrators:F /inheritance:r /t /c /q
goto install_plugins_complete
 
:install_plugins_error_admin
echo Error: This script requires admin
echo "Error: This install imc plugins requires admin" >> %jg_path_to_log_file%
GOTO install_plugins_end
 
:install_plugins_complete
echo Plugins Install complete
echo Plugins Install complete >> %jg_path_to_log_file%
%SystemRoot%\system32\cmd.exe /c %SystemRoot%\system32\WindowsPowerShell\v1.0\powershell.exe %jg_path_to_install_plugins_dir%\ThinkHotkeyPackage_\x86\Install.ps1
rd /s /q %jg_path_to_install_plugins_dir%\ThinkHotkeyPackage_

:install_plugins_end

POPD

SET jg_path_to_plugins=
SET jg_path_to_log_file=
SET jg_path_to_install_plugins_dir=
SET jg_path_to_service=
SET PrevErrorLevel=