@echo off

REM /*****************************************************************************************************/
REM /* Script file for creating driver package for MUP 2.4.3 support with driverarchive option           */
REM /* Follow the following steps to covert the driver package layout for MUP 2.4.3 support              */
REM /*    1. Copy the driver package to any folder you want                                              */
REM /*    2. Run mup_pkg_create.bat <driver_package_folder>                                              */
REM /*****************************************************************************************************/

if "%1" EQU "" goto usage

if not exist %1 goto path_not_found
if not exist %1\bin\drivers goto drivers_not_found
if not exist %1\bin\drivers\x64 goto x64_not_found

set package_root=%1

REM =============  copy files to drivers\production\Windows10-x64  =============
echo copy files from bin to bin\production\Windows10-x64...

set source_path=%package_root%\bin
set target_path=%package_root%\bin\production\Windows10-x64

mkdir %target_path%\Drivers

xcopy %source_path%\*.* %target_path% >nul
xcopy /s %source_path%\Drivers\*.* %target_path%\Drivers >nul

REM =============  remove bin\drivers\x64 and bin\drivers\x86 folder  =============
echo remove bin\drivers\x64 folder...
del /q %package_root%\bin\drivers\x64\*.*
rmdir /q %package_root%\bin\drivers\x64
rmdir /q %package_root%\bin\drivers
del /q %package_root%\bin\*.*

:finish
echo MUP driver package creation is complete!

goto end

:path_not_found
echo driver package path is not found
goto end

:drivers_not_found
echo 'bin\drivers' subfolder is not found
goto end

:x64_not_found
echo 'bin\drivers\x64' subfolder is not found
goto end

:usage
echo Usage : mup_pkg_create ^<driver package path^>

:end