//***********************************************************************
//*                        INTEL CONFIDENTIAL                           *
//***********************************************************************
// Copyright 2014 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents 
// related to the source code ("Material") are owned by Intel 
// Corporation or its suppliers or licensors. Title to the Material 
// remains with Intel Corporation or its suppliers and licensors. 
// The Material may contain trade secrets and proprietary and 
// confidential information of Intel Corporation and its suppliers and licensors, 
// and is protected by worldwide copyright and trade secret 
// laws and treaty provisions. No part of the Material may be used, 
// copied, reproduced, modified, published, uploaded, posted, 
// transmitted, distributed, or disclosed in any way without Intels 
// prior express written permission. 
//
// No license under any patent, copyright, trade secret or other 
// intellectual property right is granted to or conferred upon you by 
// disclosure or delivery of the Materials, either expressly, by 
// implication, inducement, estoppel or otherwise. Any license under 
// such intellectual property rights must be express and approved by 
// Intel in writing.

/** @file nvm_M24C64S.h */

// The EEPROM is M24C64S

#ifndef __EEPROM_M24C64S__
#define __EEPROM_M24C64S__

// [TODO] EEPROM

#define M24C64_PAGE_SIZE  32
#define M24C64_PAGE_NUM   256  
#define M24C64_SIZE       (M24C64_PAGE_SIZE * M24C64_PAGE_NUM)
#define M24C64_ADDR_MIN   0
#define M24C64_ADDR_MAX   (M24C64_SIZE - 1)

NTSTATUS
Cmd_M24c64Write(
    PNVM_CONTEXT SensorCtx,
    UINT16 Addr,
    UINT8* pData,
    INT32 Length
    );

NTSTATUS
Cmd_M24c64Read(
    PNVM_CONTEXT SensorCtx,
    UINT16 Addr,
    UINT8* pData,
    INT32 Length
    );

#endif __EEPROM_M24C64S__
