/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
#include "device.h"
#include "nvram.h"

#include "nvm_eeprom.h"
#include "nvm_brca016gwz.h"
#include "nvm_cat24c08.h"
#include "nvm_M24C64S.h"
#include "nvm_dw9806b.h"
#include "nvm_cat24c16.h"
#include "nvm_cat24c64.h"
#include "nvm_24AA16.h"
#include "nvm_dw9808.h"

// the table is to map with ACPI nvram type, and make it more regular.
NVM_TYPE NvmType[] =
{
    NVM_NONE,
    NVM_OTP,
    NVM_EEPROM,
    NVM_EEPROM,
    NVM_BIOS_OTP,
    NVM_BIOS,
    NVM_BRCA016,
    NVM_24AA32,
    NVM_CAT24C08,
    NVM_M24C64,
    NVM_DW9806B,
    NVM_CAT24C16,

    // NVM module place holder
    NVM_EX1,
    NVM_EX2,
    NVM_EX3,
    NVM_EX4,
    NVM_EX5,

    // New NVM added to last in case to change above reserved values being used externally
    NVM_CAT24C64,
    NVM_24AA16,
    NVM_DW9808,
};

// the defalut value of NVM
NVM_FUNC Nvm[NVM_NUM] =
{
    {NVM_NONE,    0,            0,                 0,                NULL,             NULL,            GetNvmData},
    {NVM_IVCAM,   0,            0,                 0,                NULL,             NULL,            GetNvmData},
    {NVM_BIOS,    0,            0,                 0,                NULL,             NULL,            GetNvmData},
    {NVM_OTP,     0,            0,                 0,                Cmd_OtpWrite,     Cmd_OtpRead,     GetNvmData},
    {NVM_BIOS_OTP,0,            0,                 0,                Cmd_OtpWrite,     Cmd_OtpRead,     GetNvmData},
    {NVM_EEPROM,  EEPROM_SIZE,  EEPROM_PAGE_SIZE,  EEPROM_ADDR_MIN,  Cmd_ErmWrite,     Cmd_ErmRead,     GetNvmData},
    {NVM_BRCA016, BRCA016_SIZE, BRCA016_PAGE_SIZE, BRCA016_ADDR_MIN, Cmd_Brca016Write, Cmd_Brca016Read, GetNvmData},
    {NVM_24AA01,  128,          8,                 0,                Cmd_ErmWrite,     Cmd_ErmRead,     GetNvmData},
    {NVM_24AA32,  4096,         32,                0,                Cmd_ErmWrite,     Cmd_ErmRead,     GetNvmData},
    {NVM_CAT24C08,CAT24C_SIZE,  CAT24C_PAGE_SIZE,  CAT24C_ADDR_MIN,  Cmd_Cat24cWrite,  Cmd_Cat24cRead,  GetNvmData},
    {NVM_M24C64,  8192,         32,                M24C64_ADDR_MIN,  Cmd_M24c64Write,  Cmd_M24c64Read,  GetNvmData},
    {NVM_DW9806B, DW9806B_SIZE, DW9806B_PAGE_SIZE, DW9806B_ADDR_MIN, Cmd_DW9806BWrite, Cmd_DW9806BRead, GetNvmData},
    {NVM_CAT24C16, CAT24C16_SIZE, CAT24C_PAGE_SIZE, CAT24C_ADDR_MIN, Cmd_Cat24c16Write, Cmd_Cat24c16Read, GetNvmData},

    // below are function callback holders, please add module above this line for inside.
    { NVM_EX1, 0, 0, 0, NULL, NULL, GetNvmData },
    { NVM_EX2, 0, 0, 0, NULL, NULL, GetNvmData },
    { NVM_EX3, 0, 0, 0, NULL, NULL, GetNvmData },
    { NVM_EX4, 0, 0, 0, NULL, NULL, GetNvmData },
    { NVM_EX5, 0, 0, 0, NULL, NULL, GetNvmData },

    // New NVM added to last in case to change above reserved mapping being used externally
    { NVM_CAT24C64, CAT24C64_SIZE, CAT24C64_PAGE_SIZE, CAT24C64_ADDR_MIN, Cmd_Cat24c64Write, Cmd_Cat24c64Read, GetNvmData },
    { NVM_24AA16, NVM_24AA16_SIZE, NVM_24AA16_PAGE_SIZE, NVM_24AA16_ADDR_MIN, Cmd_24AA16Write, Cmd_24AA16Read, GetNvmData },
    { NVM_DW9808, DW9808_SIZE, DW9808_PAGE_SIZE, DW9808_ADDR_MIN, Cmd_DW9808Write, Cmd_DW9808Read, GetNvmData },
};

