/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2010-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
*************************************************************************************************/


#ifndef _SENSOR_INTF_CLASS_
#define _SENSOR_INTF_CLASS_

/*!
 * \brief Macro for Still pipe in SDV mode
 */
//#define DISABLE_STILL_PIPE_IN_SDV


/*!
 * \brief Sensor Interface Class GUID
 *
 * \{DB53BE49-6227-48FA-A2F9-9524D27C03D7}
 */
#if !defined(SKY_CAM) && !defined(OTM_SENSOR_CONTROL_LOGIC)
static const GUID GUID_DEVINTERFACE_SENSOR =
{ 0xdb53be49, 0x6227, 0x48fa, { 0xa2, 0xf9, 0x95, 0x24, 0xd2, 0x7c, 0x3, 0xd7 } };
#endif
/*!
 * \brief Sensor Device GUID
 *
 * \OV8830 WF Config {3FE0F1ED-D0D7-AA01-D929-F78EAD789280}
 * \OV8835 WF Config {9FB34603-8C9E-41C6-A63A-F145A0FB4E24}
 * \OV2722 UF Config {B2A5AD33-08E3-4F6E-9E68-23F8B310F100}
 * \OV2722 WF Config {8F40B5E7-35D3-40E3-9D2C-334877741A3E}
 * \OV5693 WF Config {012395E3-6D6D-43EB-BEAA-7AE5EC4BC9D8}
 * \OV5645 WF Config {10E87B3B-052D-4EB4-9183-34BA61BAE1FB}
 * \OV2724 UF Config {063F9292-1DA8-45EE-B1DE-D861814C6E74}
 * \AR0543 UF Config {0F35712A-70BD-494D-9CCD-5E2DAC09CBC8}
 * \AR0330 UF Config {713E22A4-E6FB-4549-BF3D-0902A9068B06}
 * \GC2235 WF Config {CAA6E9B6-5CCF-4415-BFF1-773B8D2E646A}
 * \GC2235 UF Config {076E1022-398F-41B0-8AA7-EAA9FAA16ADB}
 * \IMX214 WF Config {7EA8D559-DDA0-4374-A0E5-086F967C61D7}
 * \IMX230 WF Config {2931127D-A2CD-483D-A876-DF2E34FD2FF1}
 * \MN34150 WF Config {CDD6871A-56CA-4386-BAE7-D24B564378A9}
 */
static const GUID OV8830_SENSOR_GUID =
{ 0x9fb34603, 0x8c9e, 0x41c6, { 0xa6, 0x3a, 0xf1, 0x45, 0xa0, 0xfb, 0x4e, 0x24 } };

static const GUID OV2720_SENSOR_GUID =
{ 0x779d75b5, 0x406f, 0x4b9c, { 0xb8, 0x6a, 0x55, 0xc2, 0x2, 0x9c, 0xc7, 0xad } };

static const GUID OV2720_SENSOR_REAR_GUID =
{ 0xb2a5ad33, 0x8e3, 0x4f6e, { 0x9e, 0x68, 0x23, 0xf8, 0xb3, 0x10, 0xf1, 0x0 } };

static const GUID OV2722_SENSOR_GUID =
{ 0x7bced037, 0xbf28, 0x4c43, { 0xa0, 0x60, 0x53, 0xe5, 0x7b, 0x8, 0xc5, 0xcc } };

static const GUID OV2722_SENSOR_REAR_GUID =
{ 0x8f40b5e7, 0x35d3, 0x40e3, { 0x9d, 0x2c, 0x33, 0x48, 0x77, 0x74, 0x1a, 0x3e } };

static const GUID MT9E013_SENSOR_GUID =
{ 0x0326ec2b, 0x7f6e, 0x43ed, { 0x99, 0x97, 0xc5, 0xa5, 0x98, 0x46, 0x9e, 0xdb } };

static const GUID DIS_SENSOR_GUID =
{ 0x6258781F, 0xDF86, 0x462B, { 0x8F, 0x9C, 0x56, 0xE8, 0x4D, 0x1D, 0x57, 0x7B } };

static const GUID OV5642_SENSOR_GUID =
{ 0xa4ca1ac2, 0x809, 0x46f0, { 0xbc, 0x60, 0xca, 0xe4, 0xf5, 0x70, 0x60, 0x39 } };

static const GUID FIFO_SENSOR_GUID =
{ 0xa6d06f47, 0x23d2, 0x4b5c, { 0x9b, 0x3c, 0x40, 0xf9, 0xbc, 0xa2, 0xbc, 0x6e } };

// {A255DEF4-F9B7-41E0-BF1E-D273ED0FEDBF}
static const GUID PIXTERIN_SENSOR_GUID =
{ 0xa255def4, 0xf9b7, 0x41e0, { 0xbf, 0x1e, 0xd2, 0x73, 0xed, 0xf, 0xed, 0xbf } };

// {FABF11E3-3EE0-4E43-8F42-84562002D424}
static const GUID PIXTERIN_SVE_SENSOR_GUID =
{ 0xfabf11e3, 0x3ee0, 0x4e43, { 0x8f, 0x42, 0x84, 0x56, 0x20, 0x2, 0xd4, 0x24 } };

// {72FBC71E-4363-469F-A0BB-98489D57A76C}
static const GUID PIXTERIN_MD_SENSOR_GUID =
{ 0x72fbc71e, 0x4363, 0x469f, { 0xa0, 0xbb, 0x98, 0x48, 0x9d, 0x57, 0xa7, 0x6c } };

// {E774ECB4-18A2-4044-B73E-B5143F8C5153}
static const GUID PIXTERIN_MD_T3_SENSOR_GUID =
{ 0xe774ecb4, 0x18a2, 0x4044, { 0xb7, 0x3e, 0xb5, 0x14, 0x3f, 0x8c, 0x51, 0x53 } };

// {E3C4B9D6-A09E-489D-90F8-820C045AD85A}
static const GUID PIXTERIN_MDSVE_SENSOR_GUID =
{ 0xe3c4b9d6, 0xa09e, 0x489d, { 0x90, 0xf8, 0x82, 0xc, 0x4, 0x5a, 0xd8, 0x5a } };

// {B343F07D-BF90-4407-A1CA-4E4A5649F5D4}
static const GUID PIXTERIN_RGBIR_SENSOR_GUID =
{ 0xb343f07d, 0xbf90, 0x4407, { 0xa1, 0xca, 0x4e, 0x4a, 0x56, 0x49, 0xf5, 0xd4 } };

static const GUID IMX175_SENSOR_GUID =
{ 0xd5b24b01, 0xff44, 0x4f5d, { 0x92, 0xea, 0x62, 0x2a, 0x44, 0xc3, 0x56, 0x6a } };

static const GUID OV9726_SENSOR_GUID =
{ 0x195bf8b9, 0xeac1, 0x4fec, { 0x98, 0xd5, 0xff, 0xe, 0x86, 0xb7, 0x81, 0xae } };

static const GUID OV5693_SENSOR_GUID =
{ 0x12395e3, 0x6d6d, 0x43eb, { 0xbe, 0xaa, 0x7a, 0xe5, 0xec, 0x4b, 0xc9, 0xd8 } };

// {626429CB-0587-43B9-A87C-8212EDE858E6}
static const GUID PIXTER2_SENSOR_GUID =
{ 0x626429cb, 0x587, 0x43b9, { 0xa8, 0x7c, 0x82, 0x12, 0xed, 0xe8, 0x58, 0xe6 } };

// {BF89B5A5-61F7-4127-A279-E187013D7CAF}
static const GUID OV5693_SENSOR_GUID_MS =
{ 0xbf89b5a5, 0x61f7, 0x4127, { 0xa2, 0x79, 0xe1, 0x87, 0x1, 0x3d, 0x7c, 0xaf } };

// {964F3F9C-F14D-41C3-AA07-5B21B57DEA38}
static const GUID OV7251_SENSOR_GUID =
{ 0x964f3f9c, 0xf14d, 0x41c3, { 0xaa, 0x7, 0x5b, 0x21, 0xb5, 0x7d, 0xea, 0x38 } };

// {6dfb8449-47e0-42d3-9e24-f13f2852a376}
static const GUID OV7251_SENSOR_GUID_MS =
{ 0x6dfb8449, 0x47e0, 0x42d3, { 0x9e, 0x24, 0xf1, 0x3f, 0x28, 0x52, 0xa3, 0x76 } };

// {EFC6C60A - 2FE9 - 4620 - A35A - B2CA2D601DE8}
static const GUID OV7251_SENSOR_GUID_MS_WFOV =
{ 0xEFC6C60A, 0x2FE9, 0x4620, { 0xA3, 0x5A, 0xB2, 0xCA, 0x2D, 0x60, 0x1D, 0xE8 } };


//MSChange
// {3374B006-18E6-49A1-A5B7-F00D17ACBF1F}
static const GUID OV9734_SENSOR_GUID_MS =
{ 0x3374b006, 0x18e6, 0x49a1, { 0xa5, 0xb7, 0xf0, 0xd, 0x17, 0xac, 0xbf, 0x1f } };

static const GUID OV8858_SENSOR_GUID =
{ 0xba5bba1a, 0xad15, 0x490d, { 0x98, 0x1, 0x7a, 0x5c, 0x85, 0xc8, 0x6c, 0xaf } };

// {A6C1C503-01F1-4767-A229-00A0B223162F}
static const GUID OV8858_SENSOR_GUID_HP =
{ 0xa6c1c503, 0x1f1, 0x4767, { 0xa2, 0x29, 0x0, 0xa0, 0xb2, 0x23, 0x16, 0x2f } };

static const GUID OV8865_SENSOR_GUID_MS =
{ 0x7c9bbcea, 0x909c, 0x47b3, { 0x8c, 0xf9, 0x2a, 0xa8, 0x23, 0x7e, 0x1d, 0x4b } };

static const GUID IMX230_SENSOR_GUID =
{ 0x2931127d, 0xa2cd, 0x483d, { 0xa8, 0x76, 0xdf, 0x2e, 0x34, 0xfd, 0x2f, 0xf1 } };

static const GUID OV5670_SENSOR_GUID =
{ 0x1538ea44, 0x83cc, 0x45c9, { 0xb9, 0x6c, 0x9f, 0x1, 0x5f, 0x3e, 0x61, 0x64 } };

// {9C5F415A-02CD-4E28-AEB7-811CB317DD64}
static const GUID OV5670_SENSOR_GUID_HP =
{ 0x9c5f415a, 0x2cd, 0x4e28, { 0xae, 0xb7, 0x81, 0x1c, 0xb3, 0x17, 0xdd, 0x64 } };

static const GUID MT9M114_SENSOR_GUID =
{ 0x72d0810, 0x2019, 0x4ddf, { 0x93, 0x83, 0x58, 0x5b, 0x56, 0x4c, 0x6b, 0x26 } };

static const GUID AR0543_SENSOR_GUID =
{ 0xf35712a, 0x70bd, 0x494d, { 0x9c, 0xcd, 0x5e, 0x2d, 0xac, 0x9, 0xcb, 0xc8 } };

static const GUID AP1302_SENSOR_GUID =
{ 0x2c458bc2, 0xd7ae, 0x4b0b, { 0xae, 0x6c, 0xc, 0x83, 0x22, 0x67, 0x9d, 0xab } };

static const GUID OV5645_SENSOR_GUID =
{ 0x10e87b3b, 0x52d, 0x4eb4, { 0x91, 0x83, 0x34, 0xba, 0x61, 0xba, 0xe1, 0xfb } };

static const GUID AR0330_SENSOR_GUID =
{ 0x713e22a4, 0xe6fb, 0x4549, { 0xbf, 0x3d, 0x9, 0x2, 0xa9, 0x6, 0x8b, 0x6 } };

static const GUID OV8835_SENSOR_GUID =
{ 0x3FE0F1ED, 0xD0D7, 0xAA01, { 0xD9, 0x29, 0xF7, 0x8E, 0xAD, 0x78, 0x92, 0x80 } };

static const GUID GC2235_SENSOR_REAR_GUID =
{ 0xcaa6e9b6, 0x5ccf, 0x4415, { 0xbf, 0xf1, 0x77, 0x3b, 0x8d, 0x2e, 0x64, 0x6a } };

static const GUID GC2235_SENSOR_FRONT_GUID =
{ 0x76e1022, 0x398f, 0x41b0, { 0x8a, 0xa7, 0xea, 0xa9, 0xfa, 0xa1, 0x6a, 0xdb } };

static const GUID HM2056_SENSOR_GUID =
{ 0x78949CB1, 0x5334, 0x4BAA, { 0x83, 0x81, 0x09, 0xCE, 0xBA, 0xF1, 0xD2, 0xB9 } };

// {D8684DA9-93A9-47D9-A05B-E4EA9E41AABE}
static const GUID HM2056_SENSOR_REAR_GUID =
{ 0xd8684da9, 0x93a9, 0x47d9, { 0xa0, 0x5b, 0xe4, 0xea, 0x9e, 0x41, 0xaa, 0xbe } };

static const GUID OV2724_SENSOR_GUID =
{ 0x63f9292, 0x1da8, 0x45ee, { 0xb1, 0xde, 0xd8, 0x61, 0x81, 0x4c, 0x6e, 0x74 } };

static const GUID IMX214_SENSOR_GUID =
{ 0x7ea8d559, 0xdda0, 0x4374, { 0xa0, 0xe5, 0x8, 0x6f, 0x96, 0x7c, 0x61, 0xd7 } };

static const GUID HM1061_SENSOR_GUID =
{ 0x2bd1302a, 0x2286, 0x4838, { 0x83, 0xa7, 0xf2, 0xc6, 0x37, 0x57, 0xa8, 0x4f } };

static const GUID OV13850_SENSOR_GUID =
{ 0xe244f653, 0xa101, 0x4621, { 0xad, 0xa7, 0x50, 0x4b, 0xd2, 0x27, 0x40, 0xc3 } };

static const GUID OV8856_SENSOR_GUID =
{ 0x3495094a, 0x2116, 0x4638, { 0xac, 0x72, 0xeb, 0x32, 0x1b, 0x13, 0x25, 0x9c } };

// {EF3D367E-112C-4083-8145-AFF0E967DB4C}
static const GUID OV8856_SENSOR_REAR_GUID =
{ 0xef3d367e, 0x112c, 0x4083, { 0x81, 0x45, 0xaf, 0xf0, 0xe9, 0x67, 0xdb, 0x4c } };

static const GUID IMX219_SENSOR_GUID =
{ 0x02C13994, 0x06D4, 0x4204, { 0x85, 0x4a, 0xbc, 0x5c, 0x1b, 0xd6, 0x35, 0x09 } };

static const GUID MN34150_SENSOR_GUID =
{ 0xcdd6871a, 0x56ca, 0x4386, { 0xba, 0xe7, 0xd2, 0x4b, 0x56, 0x43, 0x78, 0xa9 } };

// {7C819DC7-4879-4C49-A76C-E0D7ECE93E56}
static const GUID MN34150_PREEMPTIVE_GUID =
{ 0x7c819dc7, 0x4879, 0x4c49, { 0xa7, 0x6c, 0xe0, 0xd7, 0xec, 0xe9, 0x3e, 0x56 } };

// {9188B076-63AD-4CE2-927A-678714805BE6}
static const GUID IMX135_SENSOR_GUID_REAR =
{ 0x9188b076, 0x63ad, 0x4ce2, { 0x92, 0x7a, 0x67, 0x87, 0x14, 0x80, 0x5b, 0xe6 } };

// {5DA95715-CF47-426D-B683-562020B40CD5}
static const GUID IMX135_SENSOR_GUID =
{ 0x5da95715, 0xcf47, 0x426d, { 0xb6, 0x83, 0x56, 0x20, 0x20, 0xb4, 0xc, 0xd5 } };

// {3CBB4A90-315E-41BE-920F-FE10D889E626}
static const GUID IMX351_SENSOR_GUID_FRONT =
{ 0x3cbb4a90, 0x315e, 0x41be, { 0x92, 0xf, 0xfe, 0x10, 0xd8, 0x89, 0xe6, 0x26 } };

// {A4E5556A-2CA8-4802-BC54-1E3DC6302059}
static const GUID IMX351_SENSOR_GUID_REAR =
{ 0xa4e5556a, 0x2ca8, 0x4802, { 0xbc, 0x54, 0x1e, 0x3d, 0xc6, 0x30, 0x20, 0x59 } };

// {56E5301E-C30D-4ACE-A308-73F18E1ADDB7}
static const GUID IMX351_SENSOR_GUID_LEFT =
{ 0x56e5301e, 0xc30d, 0x4ace, { 0xa3, 0x8, 0x73, 0xf1, 0x8e, 0x1a, 0xdd, 0xb7 } };

// {CB9CE246-5B16-42C4-80F4-13725A94969B}
static const GUID IMX351_SENSOR_GUID_RIGHT =
{ 0xcb9ce246, 0x5b16, 0x42c4, { 0x80, 0xf4, 0x13, 0x72, 0x5a, 0x94, 0x96, 0x9b } };

// {3D808497-6B3D-46F0-9711-F484570542A0}
static const GUID IMX135_SENSOR_GUID_REAR_DUMMY =
{ 0x3d808497, 0x6b3d, 0x46f0, { 0x97, 0x11, 0xf4, 0x84, 0x57, 0x5, 0x42, 0xa0 } };

// {66E398D4-DD64-4BC9-A32B-CE78FF34E390}
static const GUID IMX135_SENSOR_GUID_DUMMY =
{ 0x66e398d4, 0xdd64, 0x4bc9, { 0xa3, 0x2b, 0xce, 0x78, 0xff, 0x34, 0xe3, 0x90 } };

// {2C704ABB-FB0A-4D2F-A8E1-51787E4E83A6}
static const GUID OV9728_SENSOR_GUID =
{ 0x2c704abb, 0xfb0a, 0x4d2f, { 0xa8, 0xe1, 0x51, 0x78, 0x7e, 0x4e, 0x83, 0xa6 } };

// {87A48B85-A02B-47BA-9148-31318AEEACFA}
static const GUID IMX132_SENSOR_GUID =
{ 0x87a48b85, 0xa02b, 0x47ba, { 0x91, 0x48, 0x31, 0x31, 0x8a, 0xee, 0xac, 0xfa } };

// {76E83AD5-7A50-4B8D-A726-90EC1EAE7229}
static const GUID IMX188_SENSOR_GUID =
{ 0x76e83ad5, 0x7a50, 0x4b8d, { 0xa7, 0x26, 0x90, 0xec, 0x1e, 0xae, 0x72, 0x29 } };

// {38F3BE7B-C170-4E79-ADC8-2AA06EB0C6CC}
static const GUID OV2740_SENSOR_GUID =
{ 0x38f3be7b, 0xc170, 0x4e79, { 0xad, 0xc8, 0x2a, 0xa0, 0x6e, 0xb0, 0xc6, 0xcc } };

// {874A0228-C780-4047-B7A7-42316427811A}
static const GUID IMX179_SENSOR_GUID =
{ 0x874a0228, 0xc780, 0x4047, { 0xb7, 0xa7, 0x42, 0x31, 0x64, 0x27, 0x81, 0x1a } };

// {8BA5B7CA-2B44-495B-9931-CE154E7ED191}
static const GUID IMX208_SENSOR_GUID =
{ 0x8ba5b7ca, 0x2b44, 0x495b, { 0x99, 0x31, 0xce, 0x15, 0x4e, 0x7e, 0xd1, 0x91 } };

// {FA3737C9-F5F8-4C9A-8CBA-0ED7EA934826}
static const GUID HM2051_SENSOR_GUID =
{ 0xfa3737c9, 0xf5f8, 0x4c9a, { 0x8c, 0xba, 0xe, 0xd7, 0xea, 0x93, 0x48, 0x26 } };

// {8A9C3481-D425-4C84-843C-2967906D64CA}
static const GUID HM2051_SENSOR_GUID_REAR =
{ 0x8a9c3481, 0xd425, 0x4c84, { 0x84, 0x3c, 0x29, 0x67, 0x90, 0x6d, 0x64, 0xca } };

// {F914C860-ECE4-4054-98CC-C3340A3F6C1B}
static const GUID HI545_SENSOR_GUID =
{ 0xf914c860, 0xece4, 0x4054, { 0x98, 0xcc, 0xc3, 0x34, 0xa, 0x3f, 0x6c, 0x1b } };

// {8244CCF5-D7DA-4159-8DEB-D6F292ECFCD3}
static const GUID OV680_SENSOR_GUID =
{ 0x737ab2ba, 0xd2c9, 0x1697, { 0xd7, 0x97, 0x1d, 0x4e, 0x8f, 0xea, 0xf4, 0x42 } };

// {B85B69A7-5AEE-4347-862A-4DF1817D5568}
static const GUID OV2680_SENSOR_GUID =
{ 0xb85b69a7, 0x5aee, 0x4347, { 0x86, 0x2a, 0x4d, 0xf1, 0x81, 0x7d, 0x55, 0x68 } };

// {DF3E2AEF-7F91-48D2-B9F5-6FBB9919AA7E}
static const GUID OV2680_SENSOR_REAR_GUID =
{ 0xdf3e2aef, 0x7f91, 0x48d2, { 0xb9, 0xf5, 0x6f, 0xbb, 0x99, 0x19, 0xaa, 0x7e } };

// {055C54C7-5B58-4DF9-A3DC-E5932D69965C}
static const GUID OV2685_SENSOR_GUID =
{ 0x55c54c7, 0x5b58, 0x4df9, { 0xa3, 0xdc, 0xe5, 0x93, 0x2d, 0x69, 0x96, 0x5c } };

// {EA49E634-94A0-43c1-988B-BB55E0DC10DD}
static const GUID HM2051_IC_SENSOR_REAR_GUID =
{ 0xea49e634, 0x94a0, 0x43c1, { 0x98, 0x8b, 0xbb, 0x55, 0xe0, 0xdc, 0x10, 0xdd } };

// {BCC8BDC4-43B0-41a8-B0C9-35D218EA79AC}
static const GUID HM2051_IC_SENSOR_FRONT_GUID =
{ 0xbcc8bdc4, 0x43b0, 0x41a8, { 0xb0, 0xc9, 0x35, 0xd2, 0x18, 0xea, 0x79, 0xac } };

// {E919C9BE-B023-4C14-A40F-DADD97244D3A}
static const GUID IMX241_SENSOR_GUID =
{ 0xe919c9be, 0xb023, 0x4c14, { 0xa4, 0xf, 0xda, 0xdd, 0x97, 0x24, 0x4d, 0x3a } };

// {3548EBBC-9E0C-4A77-B4C6-034860307EC8}
static const GUID IMX241_SENSOR_GUID_REAR =
{ 0x3548ebbc, 0x9e0c, 0x4a77, { 0xb4, 0xc6, 0x3, 0x48, 0x60, 0x30, 0x7e, 0xc8 } };

// {E62E13F6-8478-421F-B73A-A599C44761CC}
static const GUID IMX134_SENSOR_GUID =
{ 0xe62e13f6, 0x8478, 0x421f, { 0xb7, 0x3a, 0xa5, 0x99, 0xc4, 0x47, 0x61, 0xcc } };

// {F1FFD113-5A40-41DF-B7D1-37CE8E1F6EFD}
static const GUID HM8040_SENSOR_GUID =
{ 0xF1FFD113, 0x5A40, 0x41DF, { 0xB7, 0xD1, 0x37, 0xCE, 0x8E, 0x1F, 0x6E, 0xFD } };

// {649DE5B5-DF74-4C87-A104-168E88F607DC}
static const GUID IMX241_SENSOR_GUID_FRONT_SS =
{ 0x649de5b5, 0xdf74, 0x4c87, { 0xa1, 0x4, 0x16, 0x8e, 0x88, 0xf6, 0x7, 0xdc } };

// {8F80ED42-946E-4A08-A7C4-B34DB9E5D536}
static const GUID IMX241_SENSOR_GUID_REAR_SS =
{ 0x8f80ed42, 0x946e, 0x4a08, { 0xa7, 0xc4, 0xb3, 0x4d, 0xb9, 0xe5, 0xd5, 0x36 } };

// {53BBBF18-2914-4485-8152-1226C1E7D0BC}
static const GUID TPG_SENSOR_GUID_1 =
{ 0x53bbbf18, 0x2914, 0x4485, { 0x81, 0x52, 0x12, 0x26, 0xc1, 0xe7, 0xd0, 0xbc } };

// {DC65E111-332F-4782-B009-08549E68F74E}
static const GUID TPG_SENSOR_GUID_2 =
{ 0xdc65e111, 0x332f, 0x4782, { 0xb0, 0x9, 0x8, 0x54, 0x9e, 0x68, 0xf7, 0x4e } };

static const GUID OV2241_SENSOR_GUID =
{ 0xa57f982c, 0x9f46, 0x47d4, { 0xb5, 0x73, 0xc8, 0xe1, 0xb3, 0xf9, 0xba, 0xda } };

static const GUID OV2742_SENSOR_GUID =
{ 0x80c639c8, 0xd464, 0x468f, { 0x84, 0x26, 0xa0, 0xb7, 0x83, 0x62, 0xc3, 0x53 } };

// {CD59E198-F241-4ACD-BB6D-16CB977E5DDC}
static const GUID OV9234_SENSOR_GUID =
{ 0xcd59e198, 0xf241, 0x4acd, { 0xbb, 0x6d, 0x16, 0xcb, 0x97, 0x7e, 0x5d, 0xdc } };

// {27F71747-E01C-4664-9762-4E62AA2C844A}
static const GUID OV9234_SENSOR_GUID_SECONDARY =
{ 0x27f71747, 0xe01c, 0x4664, { 0x97, 0x62, 0x4e, 0x62, 0xaa, 0x2c, 0x84, 0x4a } };

// {C9EAB5B4-784A-47A2-B783-24BA0FA1F9A9}
static const GUID IMX258_SENSOR_GUID =
{ 0xc9eab5b4, 0x784a, 0x47a2, { 0xb7, 0x83, 0x24, 0xba, 0xf, 0xa1, 0xf9, 0xa9 } };

// {6C5493FE-227D-453A-9CEB-4D2DE69C5C0D}
static const GUID IMX258_SENSOR_GUID_REAR =
{ 0x6c5493fe, 0x227d, 0x453a, { 0x9c, 0xeb, 0x4d, 0x2d, 0xe6, 0x9c, 0x5c, 0xd } };

// {0B280854-F7F8-40AC-B6C3-1E5A2B7EB3C5}
static const GUID IMX318_SENSOR_GUID =
{ 0xb280854, 0xf7f8, 0x40ac, { 0xb6, 0xc3, 0x1e, 0x5a, 0x2b, 0x7e, 0xb3, 0xc5 } };

// {ACE27DEB-56DB-45A2-8FCA-D2957D66484E}
static const GUID OV13858_SENSOR_GUID =
{ 0xace27deb, 0x56db, 0x45a2, { 0x8f, 0xca, 0xd2, 0x95, 0x7d, 0x66, 0x48, 0x4e } };

// {FFCE5838-8665-4421-85C2-852A2AB4A134}
static const GUID OV13858_SENSOR_GUID_FRONT =
{ 0xffce5838, 0x8665, 0x4421, { 0x85, 0xc2, 0x85, 0x2a, 0x2a, 0xb4, 0xa1, 0x34 } };

// {d27add16-3808-4213-a227-5719b4ce2e96}
static const GUID OV13858_SENSOR_GUID_ALTERNATE =
{ 0xd27add16, 0x3808, 0x4213, { 0xa2, 0x27, 0x57, 0x19, 0xb4, 0xce, 0x2e, 0x96 } };

// {213A57B6-AACF-4210-9800-CD4C54DAE676}
static const GUID OV13858_SENSOR_GUID_MS =
{ 0x213a57b6, 0xaacf, 0x4210, { 0x98, 0x0, 0xcd, 0x4c, 0x54, 0xda, 0xe6, 0x76 } };

// {63458266-2ED6-49DB-812F-CEE7B2F7FC49}
static const GUID  OV16860_SENSOR_GUID =
{ 0x63458266, 0x2ed6, 0x49db, { 0x81, 0x2f, 0xce, 0xe7, 0xb2, 0xf7, 0xfc, 0x49 } };

// {47BC9558-C69A-4CAF-A5D0-44C91F75CE6A}
static const GUID IMX408_SENSOR_GUID =
{ 0x47bc9558, 0xc69a, 0x4caf, { 0xa5, 0xd0, 0x44, 0xc9, 0x1f, 0x75, 0xce, 0x6a } };

// {16326AA3-C40D-4004-8627-A47F1B24A86C}
static const GUID IMX408_SENSOR_GUID_REAR =
{ 0x16326aa3, 0xc40d, 0x4004, { 0x86, 0x27, 0xa4, 0x7f, 0x1b, 0x24, 0xa8, 0x6c } };

// {BA5BBA1A-AD15-490D-9801-7A5C85C86CAF}
static const GUID SAMPLE_SENSOR_GUID =
{ 0xba5bba1a, 0xad15, 0x490d, { 0x98, 0x1, 0x7a, 0x5c, 0x85, 0xc8, 0x6c, 0xaf } };

// {83CE0022-D6EC-41DE-B2C3-A0A19F6D380B}
static const GUID OV5648_SENSOR_GUID =
{ 0x83ce0022, 0xd6ec, 0x41de, { 0xb2, 0xc3, 0xa0, 0xa1, 0x9f, 0x6d, 0x38, 0xb } };

// {82A248AB-E5F1-4091-892E-A3853F5C675F}
static const GUID GC2355_SENSOR_GUID =
{ 0x82a248ab, 0xe5f1, 0x4091, { 0x89, 0x2e, 0xa3, 0x85, 0x3f, 0x5c, 0x67, 0x5f } };

// {46064452-1E0F-4809-91B2-5455D430E711}
static const GUID GC2355_REAR_SENSOR_GUID =
{ 0x46064452, 0x1e0f, 0x4809, { 0x91, 0xb2, 0x54, 0x55, 0xd4, 0x30, 0xe7, 0x11 } };

// {152351FF-178B-4895-925B-05172F8E8E6E}
static const GUID GC5005_SENSOR_GUID =
{ 0x152351ff, 0x178b, 0x4895, { 0x92, 0x5b, 0x5, 0x17, 0x2f, 0x8e, 0x8e, 0x6e } };

// {9C820F55-BEAD-4366-B9D0-3FAD5E0F0D5F}
static const GUID SP2509_SENSOR_GUID_FRONT =
{ 0x9c820f55, 0xbead, 0x4366, { 0xb9, 0xd0, 0x3f, 0xad, 0x5e, 0xf, 0xd, 0x5f } };

// {663277A7-B7D7-4A26-8FCA-925A5CA33244}
static const GUID SP2509_SENSOR_GUID_REAR =
{ 0x663277a7, 0xb7d7, 0x4a26, {0x8f, 0xca, 0x92, 0x5a, 0x5c, 0xa3, 0x32, 0x44 } };

// {A49675F7-D1CE-4C2E-AE5B-493347C4FDC5}
static const GUID GC2375_SENSOR_GUID_FRONT =
{ 0xa49675f7, 0xd1ce, 0x4c2e, { 0xae, 0x5b, 0x49, 0x33, 0x47, 0xc4, 0xfd, 0xc5 } };

// {E023266A-FF64-4827-9353-CBC2EE751FC7}
static const GUID GC2375_SENSOR_GUID_REAR =
{ 0xe023266a, 0xff64, 0x4827, { 0x93, 0x53, 0xcb, 0xc2, 0xee, 0x75, 0x1f, 0xc7 } };

// {417B8377-D211-4A1C-9146-D640345BA293}
static const GUID HM5040_SENSOR_GUID =
{ 0x417b8377, 0xd211, 0x4a1c, {0x91, 0x46, 0xd6, 0x40, 0x34, 0x5b, 0xa2, 0x93} };

// {CC9A7D85-3443-4172-9DAE-1E422C95DB09}
static const GUID SP5407_SENSOR_GUID =
{ 0xcc9a7d85, 0x3443, 0x4172, {0x9d, 0xae, 0x1e, 0x42, 0x2c, 0x95, 0xdb, 0x9} };

// {45746C8F-8853-4FD4-842A-17A78CE2D0FE}
static const GUID OV5675_SENSOR_GUID =
{ 0x45746c8f, 0x8853, 0x4fd4, { 0x84, 0x2a, 0x17, 0xa7, 0x8c, 0xe2, 0xd0, 0xfe } };

// {7B8075D0-1B7F-4F90-8CE0-CABC748DFCD2}
static const GUID OV5675_SENSOR_GUID_MS =
{ 0x7b8075d0, 0x1b7f, 0x4f90, { 0x8c, 0xe0, 0xca, 0xbc, 0x74, 0x8d, 0xfc, 0xd2 } };

// {6DE573C1-878E-426C-BC62-61C35F450F8D}
static const GUID MOCK_SENSOR_GUID_REAR =
{ 0x6de573c1, 0x878e, 0x426c, { 0xbc, 0x62, 0x61, 0xc3, 0x5f, 0x45, 0xf, 0x8d } };

// {6D41B0B4-7CC8-48AB-BE69-06CF6046C0EE}
static const GUID MOCK_SENSOR_GUID_FRONT =
{ 0x6d41b0b4, 0x7cc8, 0x48ab, { 0xbe, 0x69, 0x6, 0xcf, 0x60, 0x46, 0xc0, 0xee } };

// {2F4590AA-E4C5-43D8-9BD7-9E3003838079}
static const GUID IMX362_SENSOR_GUID_REAR =
{ 0x2f4590aa, 0xe4c5, 0x43d8, { 0x9b, 0xd7, 0x9e, 0x30, 0x3, 0x83, 0x80, 0x79 } };

// {84FE50A8-5DC0-45DA-B02D-6AC17536D7FF}
static const GUID IMX362_SENSOR_GUID =
{ 0x84fe50a8, 0x5dc0, 0x45da, { 0xb0, 0x2d, 0x6a, 0xc1, 0x75, 0x36, 0xd7, 0xff } };

// {46412EE2-DBE7-487F-BCB2-82D07A6331AA}
static const GUID IMX362_SENSOR_GUID_1 =
{ 0x46412ee2, 0xdbe7, 0x487f, { 0xbc, 0xb2, 0x82, 0xd0, 0x7a, 0x63, 0x31, 0xaa } };

// {8D34C42C-B72A-4EC2-9C74-B0D3C8920315}
static const GUID IMX362_SENSOR_GUID_2 =
{ 0x8d34c42c, 0xb72a, 0x4ec2, { 0x9c, 0x74, 0xb0, 0xd3, 0xc8, 0x92, 0x3, 0x15 } };

// {22BECE84-892A-428D-A59E-EC3B32EA9839}
static const GUID OV16880_SENSOR_GUID_MS =
{ 0x22BECE84, 0x892A, 0x428D, { 0xA5, 0x9E, 0xEC, 0x3B, 0x32, 0xEA, 0x98, 0x39 } };

// {0BCA32AB-6A7A-4595-A121-5D38B2524CAE}
static const GUID OV16880_SENSOR_GUID =
{ 0xbca32ab, 0x6a7a, 0x4595, { 0xa1, 0x21, 0x5d, 0x38, 0xb2, 0x52, 0x4c, 0xae } };

// {61EE6089-44E5-40E7-9031-33BE684FC8C9}
static const GUID IMX488_SENSOR_GUID =
{ 0x61ee6089, 0x44e5, 0x40e7, { 0x90, 0x31, 0x33, 0xbe, 0x68, 0x4f, 0xc8, 0xc9 } };

// {2657A89D-B223-4DD8-84E9-70E5799C03CA}
static const GUID IMX488_SENSOR_GUID_1 =
{ 0x2657a89d, 0xb223, 0x4dd8, { 0x84, 0xe9, 0x70, 0xe5, 0x79, 0x9c, 0x3, 0xca } };

// {38386131-DC7B-46AE-AB24-CCE6B8A9A5BB}
static const GUID IMX488_SENSOR_GUID_2 =
{ 0x38386131, 0xdc7b, 0x46ae, { 0xab, 0x24, 0xcc, 0xe6, 0xb8, 0xa9, 0xa5, 0xbb } };

// {EFED73F5-E0E1-4444-9DCB-8E0C1CBA0463}
static const GUID S5K3L6XX04_SENSOR_GUID =
{ 0xefed73f5, 0xe0e1, 0x4444, { 0x9d, 0xcb, 0x8e, 0x0c, 0x1c, 0xba, 0x04, 0x63 } };

// {75B30C21-21E1-4207-8D96-BC0F69880515}
static const GUID TOBIIT301_SENSOR_GUID =
{ 0x75b30c21, 0x21e1, 0x4207, { 0x8d, 0x96, 0xbc, 0xf, 0x69, 0x88, 0x5, 0x15 } };

// {46226EAA-A6C5-46A2-AB0B-E60980DB9113}
static const GUID IMX477_SENSOR_GUID =
{ 0x46226eaa, 0xa6c5, 0x46a2, { 0xab, 0xb, 0xe6, 0x9, 0x80, 0xdb, 0x91, 0x13 } };

// {E2785EDA-E8CA-4016-BFF9-D81DD135A579}
static const GUID AR0134_SENSOR_GUID_LEFT =
{ 0xe2785eda, 0xe8ca, 0x4016, { 0xbf, 0xf9, 0xd8, 0x1d, 0xd1, 0x35, 0xa5, 0x79 } };

// {8AE0D2DD-42DA-4695-B388-217E8F1F80D6}
static const GUID AR0134_SENSOR_GUID_RIGHT =
{ 0x8ae0d2dd, 0x42da, 0x4695, { 0xb3, 0x88, 0x21, 0x7e, 0x8f, 0x1f, 0x80, 0xd6 } };

// {45C05B82-493E-4E00-8F7D-EA9EA196CB9D}
static const GUID AR0134_SENSOR_GUID_REAR =
{ 0x45c05b82, 0x493e, 0x4e00, { 0x8f, 0x7d, 0xea, 0x9e, 0xa1, 0x96, 0xcb, 0x9d } };

// {806D58AC-5062-4E20-BF28-31C608566ECE}
static const GUID AR0134_SENSOR_GUID_FRONT =
{ 0x806d58ac, 0x5062, 0x4e20, { 0xbf, 0x28, 0x31, 0xc6, 0x8, 0x56, 0x6e, 0xce } };

// {FB8A467A-9C2E-4B71-AACE-E65CB1FA0EE3};
static const GUID OV01A_SENSOR_GUID =
{ 0xfb8a467a, 0x9c2e, 0x4b71, { 0xaa, 0xce, 0xe6, 0x5c, 0xb1, 0xfa, 0xe, 0xe3 } };

// {19EC5A54-93DF-4269-ACE4-21CA02D76E55}
static const GUID OV01A1S_SENSOR_GUID =
{ 0x19EC5A54, 0x93DF, 0x4269, { 0xac, 0xe4, 0x21, 0xca, 0x02, 0xd7, 0x6e, 0x55} };

// {6986C72D-1E71-45A8-B97A-265A94905ABC}
static const GUID OV8865_SENSOR_GUID =
{ 0x6986c72d, 0x1e71, 0x45a8, { 0xb9, 0x7a, 0x26, 0x5a, 0x94, 0x90, 0x5a, 0xbc } };

// {5FB94180-CD81-4A98-896C-AF018E6021CB}
static const GUID Chimera1_SENSOR_GUID =
{ 0x5fb94180, 0xcd81, 0x4a98, { 0x89, 0x6c, 0xaf, 0x1, 0x8e, 0x60, 0x21, 0xcb } };

// {A9447285-19F3-4D1A-A80C-CCAA49CA5971}
static const GUID Chimera2_SENSOR_GUID =
{ 0xa9447285, 0x19f3, 0x4d1a, { 0xa8, 0xc, 0xcc, 0xaa, 0x49, 0xca, 0x59, 0x71 } };

// {2691B730-EC5E-4C62-957C-94CDF03BF62E}
static const GUID Chimera3_SENSOR_GUID =
{ 0x2691b730, 0xec5e, 0x4c62, { 0x95, 0x7c, 0x94, 0xcd, 0xf0, 0x3b, 0xf6, 0x2e } };

// {E4495F6D-C849-4EC4-8862-693F9E20738A}
static const GUID Chimera4_SENSOR_GUID =
{ 0xe4495f6d, 0xc849, 0x4ec4, { 0x88, 0x62, 0x69, 0x3f, 0x9e, 0x20, 0x73, 0x8a } };

// {9BDD1C6E-2021-4089-B096-EA0FC8FDDEC5}
static const GUID OV9738_SENSOR_GUID =
{ 0x9BDD1C6E, 0x2021, 0x4089, { 0xB0, 0x96, 0xEA, 0x0F, 0xC8, 0xFD, 0xDE, 0xC5 } };
#endif
