/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef _READER_H
#define _READER_H

#include "device.h"
#include "sensor.h"

#define REG_COUNT 512*2     /*! reg count*/
#define DATA_SIZE 1024*2   /*! data size*/

/*! "brief REGS_SETTING_ARRAY
 *    reg setting array data structure
 */
typedef struct _REGS_SETTING_ARRAY
{
    REGS_SETTING arry[REG_COUNT];     /*! reg setting array*/
    ULONG size;                       /*! reg setting size*/
    ULONG max_size;                   /*! max size of setting array*/
} REGS_SETTING_ARRAY;

/*! "brief GetRegSettingFromFile
 *    get reg setting from certain file
 *
 * Arg:
 *    REGS_SETTING_ARRAY** regarry - the reg array pointer
 *    PCWSTR filepath - file path
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS GetRegSettingFromFile(
    REGS_SETTING_ARRAY** regarry,
    PCWSTR filepath
    );

#endif
