/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2018 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef _SENSOR_SKYCAM_H_
#define _SENSOR_SKYCAM_H_

typedef enum
{
    FLASH_INDICATION_IN_EMBEDDED_DATA = 0,        // Flash indication has to be extracted from frame's embedded data (flash does not use CIO2 strobe).
    // This value means that 3A/AIQ should find the flash indication in embedded data. Parsing is based on
    // sensor specific CPFF file
    FRAME_NOT_EXPOSED_TO_FLASH = 1,                // Frame was not exposed to flash
    FRAME_PARTIALLY_EXPOSED_TO_FLASH = 2,        // Frame was partially exposed to flash
    FRAME_FULLY_EXPOSED_TO_FLASH = 3            // Frame was fully exposed to flash
} FLASH_EXPOSURE_INDICATOR, *PFLASH_EXPOSURE_INDICATOR;


typedef struct _FLASH_TRIGGER_PARAMETERS
{
    ULONG TriggerDelayTnSec;    // Flash Strobe Trigger delay (in 10 nSec count). Allows a delay of up to 42.94sec. Delay from start of frame
    //  until strobe pin would set at the CIO2 device.
    // The CIO2 driver will calculate the following: TmToTrigger = (TriggerDelayTnSec*10) * 24000000 / 1000000000
    ULONG TriggerWidthTnSec;    // Duration of strobe pin pulse (in 10 nSec count). Allows a width of up to 42.94sec.
    // The CIO2 driver will calculate the following: TrgWidth = (TriggerWidthTnSec*10) * 24000000 / 1000000000
    // Note that if the PMIC is responsible for the flash duration (width), then it is set to sense the strobe's edge
    // and then the the CIO2 should generate a fairly short strobe (e.g. TriggerWidthTnSec may be 100 to generate a
    // 1uSec wide strobe). Otherwise if the PMIC is programmed to sense the strobe as level then the TriggerWidthTnSec
    // should reflect the real flash duration.
} FLASH_TRIGGER_PARAMETERS, *PFLASH_TRIGGER_PARAMETERS;

typedef struct _REQUIRED_FLASH_INTENSITY
{
    unsigned long NumberOfLEDs;            // This value counts number of LEDs that belong to a specific camera. For each of the LEDs the structure provides
    unsigned long Value[1];            // The supported range maximal possible intensity value. The provided range is defined in increments of 1 between 0 (minimum,
    // that can be OFF) and IntensityRangeMax inclusive
} REQUIRED_FLASH_INTENSITY, *PREQUIRED_FLASH_INTENSITY;

typedef enum _WLED_REPORT
{
    WLED_OK = 0,                             // WLED is OK. WLED_ISSUE_REPORT report callback would be called with this status only after another warning report has been called before,
    WLED_REACHED_TEMP_WARN_THRESHOLD,    // WLED reached the thermal warning threshold. It is still functional.
    WLED_REACHED_TEMP_SHUTDOWN,            // WLED reached the thermal shutdown threshold and is now disconnected by HW.
    WLED_FLASH_TIMEOUT,                    // WLED flash timeout occured and is now disconnected by HW. This error is a result of Sensor/PMIC driver SW bug and should not happen.
    WLED_CONTROLLER_TEMP_SHUTDOWN,        // WLED controller reached the thermal shutdown threshold and is now disconnected by HW.
    WLED_CONTROLLER_FAILURE,            // WLED controller failure.
    WLED_LOW_BATTERY_CONDITION_DETECTED    // WLED operation stopped due to detection of low battery condition
} WLED_REPORT;

typedef enum
{
    BAYER_ORDER_GRBG_NOFLIP,
    BAYER_ORDER_RGGB_NOFLIP,
    BAYER_ORDER_BGGR_NOFLIP,
    BAYER_ORDER_GBRG_NOFLIP,
    BAYER_ORDER_GRBG_H_FLIP = 4,
    BAYER_ORDER_BGGR_H_FLIP,
    BAYER_ORDER_GBRG_V_FLIP = 8,
    BAYER_ORDER_RGGB_V_FLIP,
    BAYER_ORDER_BGGR_HV_FLIP = 12,
    BAYER_ORDER_GRBG_HV_FLIP,
} TBayerOrder;

typedef enum _SNSR_BINNING_MODE
{
    BinningModeAuto = 0,
    BinningModeNone = 1,
    BinningMode2x2 = 2,
    BinningMode3x3,
    BinningMode4x4,
    BinningMode6x6 = 6,
} SNSR_BINNING_MODE;

typedef enum _SNSR_CLOCK_MODE
{
    ClockModeNormal = 0,
    ClockModeSlow,
    ClockModeMax
} SNSR_CLOCK_MODE;

typedef struct _SNSR_RESOLUTION_DEBUG
{
    UINT16 Width;
    UINT16 Height;
    ULONG CropX;    // TODO: implement cropped value in GetResolutions
    ULONG CropY;    // TODO: implement cropped value in GetResolutions
    UINT16 FPS;
    TBayerOrder BayerOrder;    // MCG F2F: it may be hard coded
    SNSR_BINNING_MODE BinningMode;
    UINT8    BPP;            // MCG took AR to include it
    ULONG  NumberOfLanes;        // TODO: Clean
    SNSR_CLOCK_MODE ClockMode;    // TODO: Clean
} SNSR_RESOLUTION_DEBUG, *PSNSR_RESOLUTION_DEBUG;
#if 1//def __cplusplus
typedef enum _SKU_VENDOR
{
    VENDOR_SEMCO,
    VENDOR_LITEON,
} SKU_VENDOR;

typedef enum _SKU_CRD
{
    DEFAULT,        // for back compatibility
    PTC,
    SKU_CRD_D,      // use GPIO pins in ctrlLogic
    SKU_CRD_G,      // one PMIC ctrl one sensor
    KILSHON_PPV,
    SKU_CRD_G2,     // one PMIC ctrl two sensor
    IMX135_CRD_D,   // use TCA9535 in sensor driver
    SKU_CRG_VALUE,   // use GPIO pins in ctrlLogic, used on BXT, same as SKU_CRD_D
    SKU_CRD_G3 = 9
} SKU_CRD;

typedef struct _SNSR_SKU
{
    UCHAR vendor : 4; //SKU_VENDOR
    UCHAR crd : 4;    //SKU_CRD
} SNSR_SKU;
#endif

#pragma warning( disable: 4201 )
typedef struct _SNSR_GAIN
{
    UINT16 AnalogueGain;
    union
    {
        UINT16 DigitalGain;
        struct
        {
            UINT16 R;
            UINT16 GR;
            UINT16 B;
            UINT16 GB;
        } DigitalGainBayer;
        struct
        {
            UINT16 R;
            UINT16 G;
            UINT16 B;
            UINT8 Enable;
        } DigitalGainRGB;
    };
} SNSR_GAIN;

// for user mode
#ifndef NTSTATUS
#define NTSTATUS LONG
#endif

// Callback definition for WLED error (mostly thermal) reporting
typedef
NTSTATUS(*WLED_ISSUE_REPORT)(
PVOID ClientContext,            // Context provided by WLED's client driver
WLED_REPORT Status                // WLED status
);

typedef enum
{
    WLED_TYPE_LONG_FOCUS = 0,    // A WLED that is focused on long distance
    WLED_TYPE_SHORT_FOCUS = 1        // A WLED that is focused on short distance
} WLED_TYPE;

typedef struct _LED_INFO
{
    ULONG IntensityRangeMax;    // The supported range maximal possible intensity value. The provided range is defined in increments of 1 between 0 (minimum,
    // that can be OFF) and IntensityRangeMax inclusive
    ULONG LedColorTemperature;    // Decimal value - in Kelvin. e.g. 5750 Kelvin value is 5750d.
    WLED_TYPE WledType;            // Type of this WLED
} LED_INFO, *PLED_INFO;


typedef struct _FLASH_INFO
{
    ULONG NumberOfLEDs;            // This value counts number of LEDs that belong to a specific camera. For each of the LEDs the structure provides
    // its intensity ranges and for each intensity rang - its maximum operational time duration. Time duration may change over time
    // per the LED usage history, as it heats up and cool down according to its usage. This requires the upper level SW to either
    // call the GetCurrentFlashIntensityRange API before every operation to get the max duration per the required intensity, or to perform
    // that call in case a ArmFlash operation fails.
    // The SDS card has a single WLED, hence [1] below
    LED_INFO LedInfo;

    BOOLEAN HwTriggerSupported;    // If TRUE, this flash device support HW trigger that can accurately synchronize the flash pulse to a frame.
    // This mode of operation requires that the imaging sensor will operate. A typical camera application should prefer this mode as
    // the HW and drivers can identify accurately which frames are exposed to the flash.
    BOOLEAN SwTriggerSupported;    // If TRUE, this flash device support SW trigger. SW operation of the flash does not require that the imaging sensor
    // will operate, but it can be used while the imaging sensor operates without synchronization to a frame.
    // This mode is useful to non camera application that wants to operate the flash in flash mode (like it does for torch mode) ???????????????????????????????should prefer this mode as
    // the HW and drivers can identify accurately which frames are exposed to the flash.
} FLASH_INFO, *PFLASH_INFO;

typedef enum _SNSR_FOCUS_STATUS
{
    FocusStopped,
    FocusMoving,
} SNSR_FOCUS_STATUS;

typedef struct _SNSR_COLORS
{
    UINT16 R;
    UINT16 GR;
    UINT16 B;
    UINT16 GB;
} SNSR_COLORS;

typedef struct _REGS_ADDR_VALUE
{
    UINT16 Reg;
    UINT8 Data;
} REGS_ADDR_VALUE;

typedef struct _SNSR_CAPS_INTERNAL
{
    UINT32 MinAnalogueGain;
    UINT32 MaxAnalogueGain;
    UINT32 MinDigitalGain;
    UINT32 MaxDigitalGain;
    UINT16 MinWidth;
    UINT16 MaxWidth;
    UINT16 MinHeight;
    UINT16 MaxHeight;
} SNSR_CAPS_INTERNAL;

// MIPI interface can be used, same as ShCss_mipi_port
#define MIPI_PORT_1LANE     0
#define MIPI_PORT_4LANE     1

// MIPI lane number
#define MIPI_LANES_1        1
#define MIPI_LANES_2        2
#define MIPI_LANES_4        4

typedef struct _SNSR_FLASH
{
    UINT8 led13FlashCurrent;
    //UINT8 led13DcCurrent;

    UINT8 led2FlashCurrent;
    //UINT8 led2DcCurrent;

    UINT16 flashTime;    // [ms]
} SNSR_FLASH;

typedef struct _SNSR_RESOLUTION_SETTING
{
    SNSR_RESOLUTION_DEBUG description;
    const REGS_ADDR_VALUE *registers;
} SNSR_RESOLUTION_SETTING;

#define STATUS_FLASH_EXTERNAL_STROBE_REQUIRED    ((STATUS_SEVERITY_SUCCESS << 30) | (1 << 29) | (0x33 << 16) | 1)


#endif
