﻿/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
#ifndef _VCM_H__
#define _VCM_H__

#include "vcm_type.h"

#include "vcm_ad5823.h"
#include "vcm_dw9714.h"
#include "vcm_ad5816.h"
#include "vcm_dw9718.h"
#include "vcm_dw9719.h"
#include "vcm_dw9806b.h"
#include "vcm_wv517s.h"
#include "vcm_lc898122XA.h"
#include "vcm_lc898212AXB.h"
#include "vcm_ak7371.h"
#include "vcm_bu64297gwz.h"
#include "vcm_dw9800.h"
#include "vcm_dw9808.h"

#define DELAY_PER_STEP_NS           10000
#define DELAY_MAX_PER_STEP_NS       (10000*40)
#define SPB_WRITE_TRANSFERS         1


/*! "brief VCM_FUNC
 *    data structure of vcm function
 */
typedef struct __VCM_FUNC_
{
    VCM_TYPE                   Type;          /*! vcm type*/
    const CHAR*                Name;          /*! vcm name*/
    USHORT                     DefaultPos;    /*! vcm default position*/
    VCM_COMMON_FUNC            Init;          /*! function init*/
    VCM_COMMON_FUNC            ResetPos;      /*! function reset position*/
    SNSR_SET_FOCUS_POS         SetPos;        /*! function set position*/
    SNSR_GET_FOCUS_POS         GetPos;        /*! function get position*/
    SNSR_GET_FOCUS_STATUS      GetStatus;     /*! function get status*/
    SNSR_GET_FOCUS_HP_STATUS   GetHPStatus;   /*! function get home postion status*/
    SNSR_SET_VCM_CONFIGURATION SetVcmConfig;  /*! function set vcm config*/
} VCM_FUNC;

extern USHORT Vcm_DefaultFocus[VCM_NUM];
extern VCM_COMMON_FUNC Vcm_Init[VCM_NUM];
extern VCM_COMMON_FUNC Vcm_ResetPosition[VCM_NUM];
extern SNSR_SET_FOCUS_POS Vcm_SetFocusPos[VCM_NUM];
extern SNSR_GET_FOCUS_POS Vcm_GetFocusPos[VCM_NUM];
extern SNSR_GET_FOCUS_STATUS Vcm_GetFocusStatus[VCM_NUM];
extern SNSR_GET_FOCUS_HP_STATUS Vcm_GetFocusHPStatus[VCM_NUM];
extern SNSR_SET_VCM_CONFIGURATION Vcm_SetVcmConfiguration[VCM_NUM];

/*! "brief InitContextVcm
 *    init vcm context
 *
 * Arg:
 *    PVCM_CONTEXT pSsVcm - context pointer of vcm
 * Return:
 *    NTSTATUS - status
 */
void InitContextVcm(
    PVCM_CONTEXT pSsVcm
    );

/*! "brief InitVcm
 *    init vcm
 *
 * Arg:
 *    PVCM_CONTEXT pSsVcm - context pointer of vcm
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS InitVcm(
    PVCM_CONTEXT pSsVcm
    );

/*! "brief ResetVcmPosition
 *    reset vcm position
 *
 * Arg:
 *    PVCM_CONTEXT pSsVcm - context pointer of vcm
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS ResetVcmPosition(
    PVCM_CONTEXT pSsVcm
    );

/*! "brief DetectVcm
 *    detect vcm
 *
 * Arg:
 *    PVCM_CONTEXT pSsVcm - context pointer of vcm
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS DetectVcm(
    PVCM_CONTEXT pSsVcm
    );

/*! "brief TraceLogVcm
 *    trace log for vcm
 *
 * Arg:
 *    PVCM_CONTEXT pSsVcm - context pointer of vcm
 *    const char* str - string to print
 *    unsigned int arg0 - data to print
 *    unsigned int arg1 - data to print
 * Return:
 *    NTSTATUS - status
 */
void TraceLogVcm(
    PVCM_CONTEXT pSsVcm,
    const char* str,
    unsigned int arg0,
    unsigned int arg1
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmRead0(
    PVCM_CONTEXT pSsVcm,
    UINT8 Addr,
    UINT8 *Data
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmWrite0(
    PVCM_CONTEXT pSsVcm,
    UINT8 Addr,
    UINT8 Data
    );

/*! "brief vcmRead1
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmRead1(
    PVCM_CONTEXT pSsVcm,
    UINT16 *Data
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmWrite1(
    PVCM_CONTEXT pSsVcm,
    UINT8 Data0,
    UINT8 Data1
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmRead2(
    PVCM_CONTEXT pSsVcm,
    UINT16 Addr,
    UINT8 *Data
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmWrite2(
    PVCM_CONTEXT pSsVcm,
    UINT16 Data0,
    UINT8 Data1
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmRead3(
    PVCM_CONTEXT pSsVcm,
    UINT8 Addr,
    UINT16 *Data
    );

/*! "brief ResetVcmPosition
*    reset vcm position
*
* Arg:
*    PVCM_CONTEXT pSsVcm - context pointer of vcm
* Return:
*    NTSTATUS - status
*/
NTSTATUS vcmWrite3(
    PVCM_CONTEXT pSsVcm,
    UINT8 AddrData,
    UINT16 Data1
    );

#endif
