/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is dw9718
#ifndef __VCM_DW9718__
#define __VCM_DW9718__

//VCM configuration
#define DW9718_DEFAULT_POS    1
#define DW9718_MIN_FOCUS_POS        1    //150
#define DW9718_MAX_FOCUS_POS        1023 //350
#define DW9718_HOME_FOCUS_POS       DW9718_MIN_FOCUS_POS
#define DW9718_VCM_RUN_STEPS        32
#define DW9718_VCM_RESET_DELAY      1
#define FocusPos_DataM_Addr  0x02
#define FocusPos_DataL_Addr  0x03

NTSTATUS DW9718_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9718_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9718_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS DW9718_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS DW9718_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS DW9718_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS DW9718_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

NTSTATUS DW9718_Test(
    PVCM_CONTEXT pSsVcm
    );

#endif __VCM_DW9718__
