/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef __SAMPLE_DEVICE_H__
#define __SAMPLE_DEVICE_H__

#pragma once

#include <ntifs.h>
#include <ntddk.h>
#include <wdf.h>
#define NTSTRSAFE_LIB
#include <ntstrsafe.h>
#include <spb.h>
#include <Acpiioct.h>
#include <reshub.h>
#include <gpio.h>
#include "sensor_intf.h"
#include "sensor_intfclass.h"
#include "dsdt.h"
#include <stdlib.h>


//defines
#define SENSOR_GUID     SAMPLE_SENSOR_GUID
#define SENSOR_ID       0x0000
#define SENSOR_ID_EX    0x0000
#define SENSOR_NAME     "SAMPLE"
#define DEVICE_NAME     SENSOR_NAME
#define POOL_TAG        'SAMP'

#define DELAY_PWDN      10
#define DELAY_RST_PULSE 2
#define DELAY_RST       20
#define W_EXT           16
#define H_EXT           16


//registers
#define REG_SENSOR_ID                   0x0 //16bitss
#define REG_SENSOR_VERSION              0x0 //16bits
#define REG_EXPOSURE                    0x0 //24bits
#define REG_ANA_GAIN                    0x0 //11bits
#define REG_DIGITAL_GAIN                0x0 //12bits
#define REG_MWB_GAIN_R                  0x0 //16bits
#define REG_MWB_GAIN_G                  0x0 //16bits
#define REG_MWB_GAIN_B                  0x0 //16bits
#define REG_AWBM_GAIN_R                 0x0 //12bits
#define REG_AWBM_GAIN_G                 0x0 //12bits
#define REG_AWBM_GAIN_B                 0x0 //12bits
#define REG_GROUP_ACCESS                0x0 //8bits
#define REG_Y_MEAN                      0x0 //8bits

#define REG_H_START                     0x0 //16bits
#define REG_V_START                     0x0 //16bits
#define REG_H_END                       0x0 //16bits
#define REG_V_END                       0x0 //16bits
#define REG_WIDTH                       0x0 //16bits
#define REG_HEIGHT                      0x0 //16bits
#define REG_TIMING_HTS                  0x0 //16bits
#define REG_TIMING_VTS                  0x0 //16bits

#define REG_TIMING_X_INC                0x0 //8bits
#define REG_TIMING_Y_INC                0x0 //8bits
//mode data information
#define MODE_DATA_FRAME_ADDR            REG_H_START
#define MODE_DATA_FRAME_NUM             ((REG_TIMING_VTS - REG_H_START)/2 + 1)

#define REG_PLL2_PREDIV0                0x0 //[1:0]
#define REG_PLL2_PREDIV                 0x0 //[1:0]
#define REG_PLL2_MULTIPLIER_H           0x0 //[4:0]
#define REG_PLL2_MULTIPLIER_L           0x0 //[4:0]
#define REG_PLL2_DAC_DIVIDER            0x0 //[3:0]
#define REG_PLL2_SYS_PRE_DIV2           0x0 //[3:0]
#define REG_PLL2_SYS_DIVIDER            0x0 //[2:0]

#define REG_PLL2_SYS_PRE_DIV            0x0 //[3:0]
#define REG_PLL2_SCLK_PDIV              0x0 //[3:0]
#define REG_PLL2_SCLK_BYPASS            0x0 //[0]


#define REG_FLIP_CONTROL                0x0
#define REG_MIRROR_CONTROL              0x0
#define CONFIG_FLIP                     0x0                     
#define CONFIG_MIRROR                   0x0

#define REG_PLL1_PREDIV0                0x0 //[1:0]
#define REG_PLL1_PREDIV                 0x0 //[1:0]
#define REG_PLL1_MULTIPLIER_H           0x0
#define REG_PLL1_MULTIPLIER_L           0x0
#define REG_PLL1_M_DIVIDER              0x0
#define REG_PLL1_MIPI_DIVIDER           0x0

#define SAMPLE_ID_DEFAULT			0
#define SAMPLE_SUNNY				1
#define SAMPLE_OTP_START_ADDR		0x0
#define SAMPLE_OTP_END_ADDR			0x0



#define SAMPLE_OTP_LOAD_CTRL			0x0
#define SAMPLE_OTP_MODE_CTRL			0x0
#define SAMPLE_OTP_START_ADDR_REG		0x0
#define SAMPLE_OTP_END_ADDR_REG			0x0
#define SAMPLE_OTP_ISP_CTRL2			0x0
#define SAMPLE_STREAM_MODE				0x0
#define SAMPLE_OTP_MODE_MANUAL			0x0
#define SAMPLE_OTP_MODE_PROGRAM_DISABLE 0x0
#define SAMPLE_OTP_LOAD_ENABLE			0x0
#define SAMPLE_OTP_DPC_ENABLE			0x0

#define OTP_BANK_SIZE                   16
#define OTP_BANK_NUM                    27     //bank1~bank27
#define OTP_SIZE                        (SAMPLE_OTP_END_ADDR - SAMPLE_OTP_START_ADDR + 1)
#define OTP_VALID_SIZE                  (OTP_SIZE)

// embedded line
#define EMBED_EN         (1 << 0)
#define REG_EMBED_CTRL                  0x0 //8bits
#define REG_EMB_DT_SEL                  0x0 //8bits
#define DSP_CTRL                        0x0 //8bits
#define EMBED_FLAG                      0x0 //8bits

#define REG_EXPGAIN_INVALID             ((UINT16) 0xFFFF)


#include "sensor.h"

NTSTATUS LocalCmd_SetExtFeature(
    PDEVICE_CONTEXT SensorCtx,
    SNSR_EXT_FEATURE_ID feature,
    ULONG_PTR Value
    );

NTSTATUS LocalCmd_SetExposure(
    PDEVICE_CONTEXT SensorCtx,
    SNSR_EXPOSURE ExposureTime
    );

NTSTATUS LocalCmd_GetExposure(
    PDEVICE_CONTEXT SensorCtx,
    SNSR_EXPOSURE *Exposure
    );

NTSTATUS LocalCmd_GetGain(
    PDEVICE_CONTEXT SensorCtx,
    ULONG *Gain
    );

#endif // __SAMPLE_DEVICE_H__
