﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using Windows.ApplicationModel.Email.DataProvider;
using Windows.Media.Capture.Core;

namespace FwUpdateApiSample
{

    internal class SecurityRevisionImageValidator : ImageValidator
    {

        internal SecurityRevisionImageValidator(SdkTbtBase controller,
                                                byte[] image,
                                                Dictionary<Sections, FwInfo.SectionDetails> controllerSections,
                                                Dictionary<Sections, FwInfo.SectionDetails> fileSections,
                                                HwInfo hwInfo)
            : base(controller, image, controllerSections, fileSections, hwInfo)
        {
        }

        protected override IEnumerable<CheckLocation> GetCheckLocations(HwGeneration generation)
        {
            switch (generation)
            {
                default:
                    return new[]
                    {
                        new CheckLocation(offset: 0x2c, length: 4, description: "Security revision", section: Sections.CSS)
                    };
            }
        }

        internal override void Validate()
        {
            var securityRevisionLocation = GetCheckLocations(HwInfo.Generation).First();
            var fileSecurityRevision = BitConverter.ToUInt32(ReadFromFile(securityRevisionLocation), 0);
            var fwSecurityRevision = BitConverter.ToUInt32(ReadFromFw(securityRevisionLocation), 0);
            if (fileSecurityRevision < fwSecurityRevision)
            {
                throw new TbtException(TbtStatus.SDK_IMAGE_VALIDATION_ERROR,
                    Resources.ValidationFailedSecurityRevision + "\n" + Resources.ValidationFailedPart2);
            }
        }
    }

}
