/*******************************************************************************
** INTEL CONFIDENTIAL
**
** Copyright (c) 2019-2020 Intel Corporation All Rights Reserved
**
** The source code contained or described herein and all documents related to
** the source code ("Material") are owned by Intel Corporation or its suppliers
** or licensors.
**
** Title to the Material remains with Intel Corporation or its suppliers and
** licensors. The Material contains trade secrets and proprietary and
** confidential information of Intel or its suppliers and licensors, and is
** protected by worldwide copyright and trade secret laws and treaty
** provisions. No part of the Material may be used, copied, reproduced,
** modified, published, uploaded, posted, transmitted, distributed, or disclosed
** in any way without Intels prior express written permission.
**
** No license under any patent, copyright, trade secret or other intellectual
** property right is granted to or conferred upon you by disclosure or delivery
** of the Materials, either expressly, by implication, inducement, estoppel or
** otherwise. Any license under such intellectual property rights must be
** express and approved by Intel in writing.
**
*******************************************************************************/
/*++

Module Name:

    cvf_camera_intf.h

Abstract:

    This module contains the common declarations shared by driver
    and user applications.

Environment:

    user and kernel

*/

#pragma once

//
// Define an Interface Guid so that apps can find the device and talk to it.
//

#if !defined(_GUID_DEVINTERFACE_CVF_DEFINED)
#define _GUID_DEVINTERFACE_CVF_DEFINED
DEFINE_GUID(GUID_DEVINTERFACE_CVF,
    0x5ed41ea9, 0xe376, 0x428b, 0xa4, 0x65, 0x7e, 0xd6, 0xf4, 0xd6, 0xd0, 0x99);
// {5ed41ea9-e376-428b-a465-7ed6f4d6d099}
#endif

// {CCEC3AC9-F8BC-49AE-8C44-7C3BD0483A6D}
DEFINE_GUID(GUID_DEVINTERFACE_CVF_CAMERA_API,
    0xccec3ac9, 0xf8bc, 0x49ae, 0x8c, 0x44, 0x7c, 0x3b, 0xd0, 0x48, 0x3a, 0x6d);

// {06B824F4-098C-474A-8DB1-F8D2F79A0DDB}
DEFINE_GUID(GUID_DEVINTERFACE_CVF_CAMERA_API_VER_12,
    0x6b824f4, 0x98c, 0x474a, 0x8d, 0xb1, 0xf8, 0xd2, 0xf7, 0x9a, 0xd, 0xdb);

#define CVF_CAMERA_INTERFACE_VERSION        10
#define CVF_CAMERA_INTERFACE_VERSION_12     10

typedef enum _CVF_SNSR_TYPE
{
    CVF_BAYER_RGB,
    CVF_MONO_IR,
    CVF_RGBIR,
    // ...
    CVF_Type_Specifier = 0xffffffff,    // C++ 11 allows [: type], 'C' does not.
                                        // Enforce enum type/size here
} CVF_SNSR_TYPE;

typedef struct _INIT_CONFIG
{
    CVF_SNSR_TYPE SensorType;
    UINT32        SensorOrientation;
    // ...
} INIT_CONFIG, *PINIT_CONFIG;

typedef struct _MIPI_CONFIG
{
    UINT32 Frequency;
    UINT32 Lanes;
    // ...
} MIPI_CONFIG, *PMIPI_CONFIG;

typedef struct _CVF_SNSR_EXPO
{
    USHORT FineIntegrationTime;    // Fine exposure time (Mandatory)
    USHORT CoarseIntegrationTime;  // Coarse exposre time (Mandatory)
    USHORT AnalogGain;             // Analog gain (Mandatory)
    USHORT DigitalGain;            // Digital gain (Mandatory)
    USHORT LineLengthPixels;       // LineLengthPixels (Mandatory)
    USHORT FrameLengthLines;       // Frame length lines (Mandatory)
} CVF_SNSR_EXPO, *PCVF_SNSR_EXPO;

//
// Camera Callback Function
//
typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_SET_PRIVACY_STATE)
NTSTATUS
CVF_CAMERA_SET_PRIVACY_STATE(
    _In_ PVOID CameraContext,
    _In_ UINT32 PrivacyState
);
typedef CVF_CAMERA_SET_PRIVACY_STATE * PCVF_CAMERA_SET_PRIVACY_STATE;

typedef struct _CVF_ACQUIRE_SENSOR_INFO_VER_12
{
    USHORT Privacy;               // Privacy State 0=Off, 1=On
    USHORT Reserved;
    PCVF_CAMERA_SET_PRIVACY_STATE PrivacyStateCallBack;
    PVOID CameraContext;
    MIPI_CONFIG MipiConfig;
} CVF_ACQUIRE_SENSOR_INFO_VER_12, *PCVF_ACQUIRE_SENSOR_INFO_VER_12;

//
// Define Interface routines for
//  Interfaces exported by IRP_MN_QUERY_INTERFACE
//
// Versiion 10
//
typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_INIT)
NTSTATUS
CVF_CAMERA_INIT(
    _In_ PVOID CvfContext,
    _In_ const PINIT_CONFIG Config
);
typedef CVF_CAMERA_INIT * PCVF_CAMERA_INIT;

typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_SET_PRIVACY_CALLBACK)
NTSTATUS
CVF_CAMERA_SET_PRIVACY_CALLBACK(
    _In_ PVOID CvfContext,
    _In_ PCVF_CAMERA_SET_PRIVACY_STATE PrivacyStateCallBack,
    _In_ PVOID CameraContext
);
typedef CVF_CAMERA_SET_PRIVACY_CALLBACK * PCVF_CAMERA_SET_PRIVACY_CALLBACK;

typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_ACQUIRE_SENSOR)
NTSTATUS
CVF_CAMERA_ACQUIRE_SENSOR(
    _In_  PVOID CvfContext,
    _Out_ PCVF_SNSR_EXPO Exposure
);
typedef CVF_CAMERA_ACQUIRE_SENSOR * PCVF_CAMERA_ACQUIRE_SENSOR;

typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_RELEASE_SENSOR)
NTSTATUS
CVF_CAMERA_RELEASE_SENSOR(
    _In_ PVOID CvfContext,
    _In_ const PCVF_SNSR_EXPO Exposure
);
typedef CVF_CAMERA_RELEASE_SENSOR * PCVF_CAMERA_RELEASE_SENSOR;

typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_SET_MIPI_CONFIG)
NTSTATUS
CVF_CAMERA_SET_MIPI_CONFIG(
    _In_ PVOID CvfContext,
    _In_ const PMIPI_CONFIG Config
);
typedef CVF_CAMERA_SET_MIPI_CONFIG * PCVF_CAMERA_SET_MIPI_CONFIG;

//
// Version 12
//
typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_ACQUIRE_SENSOR_VER_12)
NTSTATUS
CVF_CAMERA_ACQUIRE_SENSOR_VER_12(
    _In_ PVOID CvfContext,
    _In_ PCVF_ACQUIRE_SENSOR_INFO_VER_12 Info
);
typedef CVF_CAMERA_ACQUIRE_SENSOR_VER_12 * PCVF_CAMERA_ACQUIRE_SENSOR_VER_12;

typedef
_IRQL_requires_same_
_Function_class_(CVF_CAMERA_RELEASE_SENSOR_VER_12)
NTSTATUS
CVF_CAMERA_RELEASE_SENSOR_VER_12(
    _In_ PVOID CvfContext
);
typedef CVF_CAMERA_RELEASE_SENSOR_VER_12 * PCVF_CAMERA_RELEASE_SENSOR_VER_12;

//
// Interface Version 10
//
typedef struct _CVF_INTERFACE_CAMERA
{
    INTERFACE                           InterfaceHeader;
    PCVF_CAMERA_INIT                    Init;
    PCVF_CAMERA_ACQUIRE_SENSOR          AcquireSensor;
    PCVF_CAMERA_RELEASE_SENSOR          ReleaseSensor;
    PCVF_CAMERA_SET_MIPI_CONFIG         SetMipiConfig;
    PCVF_CAMERA_SET_PRIVACY_CALLBACK    SetPrivacyCallBack;
} CVF_INTERFACE_CAMERA, *PCVF_INTERFACE_CAMERA;

//
// Interface Version 12
//
typedef struct _CVF_INTERFACE_CAMERA_VER_12
{
    INTERFACE                           InterfaceHeader;
    PCVF_CAMERA_ACQUIRE_SENSOR_VER_12   AcquireSensor;
    PCVF_CAMERA_RELEASE_SENSOR_VER_12   ReleaseSensor;
} CVF_INTERFACE_CAMERA_VER_12, *PCVF_INTERFACE_CAMERA_VER_12;
