/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/




#ifndef _CONTROLLOGIC_COMMON_H
#define _CONTROLLOGIC_COMMON_H

#include <ntddk.h>

/*
* \brief Camera Board Version
*   Equal to CRD-Version
*/
typedef enum _BOARD_VERSION
{
    BOARD_VERSION_UNKNOWN,
    CRD_PTC = 0x10,
    CRD_D = 0x20,
    CRD_G = 0x30,
    CRD_PPV  = 0x40,
    CRD_G2 = 0x50,
    CRD_G_VALUE = 0x70,
    CRD_TEST = 0x80,
    CRD_G3 = 0x90,
    CRD_BRIDGE_CHIP = 0xA0
} BOARD_VERSION;


/*
* \brief Pmic type 
*/
typedef enum _PMIC_TYPE
{
    PMIC_TYPE_UNKNOWN,
    PMIC_DISCRETE,
    PMIC_TPS68470,
    PMIC_UP6641,
    PMIC_TEST
} PMIC_TYPE;

#define DISCRETE_NAME "DISCRETE"
#define TPS68470_NAME "TPS68470"
#define UP6641_NAME   "UP6641"

/*!
* \brief PMIC Interface Class GUID
*
* \{540CEFCB-DA1C-485E-BDB3-B3E11FFFCB44}
*/
static const GUID ControlLogicInterfaceClass =
{ 0x540CEFCB, 0xDA1C, 0x485E, { 0xBD, 0xB3, 0xB3, 0xE1, 0x1F, 0xFF, 0xCB, 0x44 } };

/*
* PMIC infomation
*/
typedef struct _CONTROLLOGIC_INFO
{
    ULONG ControlLogicID; 
    BOARD_VERSION BoardType;
    PMIC_TYPE PmicType;
    ULONG Reserved[10];
}CONTROLLOGIC_INFO;

#endif