//*****************************************************************************
// INTEL CORPORATION PROPRIETARY INFORMATION
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Intel Corporation and may not be 
// copied or disclosed except in accordance with the terms of that 
// agreement
//
// Copyright ?2010 Intel Corporation. All Rights Reserved.
//*****************************************************************************

#ifndef __VCM_AD5823__
#define __VCM_AD5823__

// VCM registers
#define AD5823_VCM_RESET               0x01
#define AD5823_VCM_MODE                0x02
#define AD5823_VCM_MOVE_TIME           0x03
#define AD5823_VCM_CODE_MSB            0x04
#define AD5823_VCM_CODE_LSB            0x05
#define AD5823_VCM_THRESHOLD_MSB       0x06
#define AD5823_VCM_THRESHOLD_LSB       0x07

// VCM configuration
#define AD5823_MIN_FOCUS_POS        1
#define AD5823_MAX_FOCUS_POS        1023
#define AD5823_HOME_FOCUS_POS       AD5823_MIN_FOCUS_POS
#define AD5823_VCM_RUN_STEPS        32
#define AD5823_VCM_RESET_DELAY      1
#define AD5823_DEFAULT_POS    1

NTSTATUS AD5823_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS AD5823_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS AD5823_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS AD5823_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS AD5823_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS AD5823_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS AD5823_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

#endif __VCM_AD5823__
