/*******************************************************************************
** INTEL CONFIDENTIAL
**
** Copyright (c) 2020 Intel Corporation All Rights Reserved
**
** The source code contained or described herein and all documents related to
** the source code ("Material") are owned by Intel Corporation or its suppliers
** or licensors.
**
** Title to the Material remains with Intel Corporation or its suppliers and
** licensors. The Material contains trade secrets and proprietary and
** confidential information of Intel or its suppliers and licensors, and is
** protected by worldwide copyright and trade secret laws and treaty
** provisions. No part of the Material may be used, copied, reproduced,
** modified, published, uploaded, posted, transmitted, distributed, or disclosed
** in any way without Intels prior express written permission.
**
** No license under any patent, copyright, trade secret or other intellectual
** property right is granted to or conferred upon you by disclosure or delivery
** of the Materials, either expressly, by implication, inducement, estoppel or
** otherwise. Any license under such intellectual property rights must be
** express and approved by Intel in writing.
**
*******************************************************************************/
/*++

Module Name:

    PrivacyMode.h

Abstract:

    This module contains the macro and data structures used for WMI privacy mode interface.

Environment:

    kernel

*/

#pragma once

//
// Define an Guid of the WMI event defined in the MOF file of customer.
//
// {9DBB5994-A997-11DA-B012-B622A1EF5492}
DEFINE_GUID(GUID_OEM_PRIVACYMODE_WMI_EVENT,
    0x9dbb5994, 0xa997, 0x11da, 0xb0, 0x12, 0xb6, 0x22, 0xa1, 0xef, 0x54, 0x92);

#define PRIVACY_EVENT_TYPE 0x0012
#define PRIVACY_EVENT_SUBTYPE 0x0E
#define CHANGE_CODE_CAMERA_MUTE 0x02
#define PRIVACY_EVENT_CAMERA_STATUS 0x02

//
// Define the data structure of the privacy status according to the data
// block in the MOF file of customer.
//
typedef struct _PRIVACY_STATUS
{
    // WORD 0 - The number of words following in the buffer
    USHORT BufferLength;

    // WORD 1 - The event type as defined below. For Privacy notification, we will use type 0x0012.
    USHORT EventType;

    // WORD 2 - Sub-Type of the Event (0x0E)
    USHORT SubType;

    // WORD 3 - Will contain the change code (this will enable to us to extend this feature
    // to additional hardware entities in the future.
    // 1 - Mic Mute
    // 2 - Camera Mute
    // 3 - Privacy Screen
    USHORT ChangeCode;

    // WORD 4 - Status information of the Privacy feature in bit-field format (0 indicates the
    // Device is Off/Muted, 1 indicates the device is On/usable/Un-Muted.
    // Bit 0 - Microphone Status
    // Bit 1 - Camera Status
    // Bit 2 - Privacy Screen
    USHORT Status;
} OEM_PRIVACY_STATUS, *POEM_PRIVACY_STATUS;

#define PRIVACY_STATUS_BUFFER_LENGTH (sizeof(OEM_PRIVACY_STATUS) / sizeof(USHORT) - 1)

//
// Define an Guid of the WMI data block of device state defined in the MOF file of customer.
//
// {6932965F-1671-4CEB-B988-D3AB0A901919}
DEFINE_GUID(GUID_OEM_DEVICE_STATE,
    0x6932965f, 0x1671, 0x4ceb, 0xb9, 0x88, 0xd3, 0xab, 0x0a, 0x90, 0x19, 0x19);

typedef struct _DEVICE_STATE
{
    // 0 - None, 0x1 - Microphone, 0x2 - Camera, 0x4 - ePrivacy Screen
    ULONG DevicesSupported;

    // 0:Off; 1:On. Bit0 - Microphone, Bit1 - Camera, Bit2 - ePrivacyScreen
    ULONG CurrentState;
} OEM_DEVICE_STATE, *POEM_DEVICE_STATE;

#define DEVICE_STATE_CAMERA_MASK 0x02

// if privacy is on, this function should assign 1 to PrivacyState
// if privacy is off, this function should assign 0 to PrivacyState
typedef
NTSTATUS
(*PQUERY_PRIVACY_STATE)(
    PVOID Context,
    PVOID PrivacyState
    );

