/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// Current version: 0.2, Feb 04, 2016. Corrected enum #4 in MIPI_LINK_SECURITY_ATTRIBUTE (it's name was as of enum #3)
//                  0.1, Jan 14, 2016. Initial draft with VTIO support.



#ifndef _VTIO_BIOS_MANIFEST_H
#define _VTIO_BIOS_MANIFEST_H

//#include "public.h"

// Enumeration of MIPI link security attributes
typedef enum
{
    MIPI_LINK_NC                = 0,    // MIPI link is not connected. In case there is a sensor driver that claims this link, then
                                        // this situation is a BIOS inconsistency and the drivers should treat it as ALWAYS_NON_SECURED link.
    ALWAYS_NON_SECURED          = 1,    // MIPI link can only beused as a non secured camera (legacy applications would not be able to use it)
    ALWAYS_SECURED              = 2,    // MIPI link can only beused as a secured camera (legacy applications would not be able to use it)
    DYNAMIC_DEFAULT_NON_SECURED = 3,    // MIPI link can be used as non secured or as secured - depends on application request. Power up
                                        // default for this link is non secured (makes it ready for use by legacy applications. Secured
                                        // applications would need to set its property to secured)
    DYNAMIC_DEFAULT_SECURED     = 4     // MIPI link can be used as non secured or as secured - depends on application request. Power up
                                        // default for this link is secured (legacy applications would not be able to use it without set
                                        // its property to non secured)

                                        // Note: This enum is used by the MIPI_LINK_SECURITY_ASSIGNMENT links, hence its values should
                                        //         consume 4 bits. Values 5 to 15 are reserved for future use.
} MIPI_LINK_SECURITY_ATTRIBUTE;


// Note: The following structure (bit fields), is defined as 32 bits and supports KBL, BXT and CNL
//         For KBL, link0 .. link3 are supported (unused/unconnected links should specify LINK_NC).
//         For BXT and CNL, link0 .. link5 are supported (unused/unconnected links should specify LINK_NC).
typedef struct _MIPI_LINKS_SECURITY_ASSIGNMENT
{
    unsigned int  link0 : 3;            // One of MIPI_LINK_SECURITY_ATTRIBUTE
    unsigned int  link1 : 3;            // One of MIPI_LINK_SECURITY_ATTRIBUTE
    unsigned int  link2 : 3;            // One of MIPI_LINK_SECURITY_ATTRIBUTE
    unsigned int  link3 : 3;            // One of MIPI_LINK_SECURITY_ATTRIBUTE
    unsigned int  link4 : 3;            // One of MIPI_LINK_SECURITY_ATTRIBUTE
    unsigned int  link5 : 3;            // One of MIPI_LINK_SECURITY_ATTRIBUTE
    unsigned int  Resrvd : 14;            // Reserved - MBZ
} MIPI_LINKS_SECURITY_ASSIGNMENT, *PMIPI_LINKS_SECURITY_ASSIGNMENT;


#endif
