/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2014-2020 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef _PLATF_INFO_H_
#define _PLATF_INFO_H_

// IPU version & Platform versions
typedef enum _IPU_VERSION
{
    IPU_Unk,
    IPU_4,
    IPU_4P,
    IPU_5,
    IPU_6,
    IPU_6SE
} IPU_VER;

typedef enum _PLATFORM_VERSION
{
    PLT_Unk,
    PLT_APL,
    PLT_BXTHR,
    PLT_CNL_Bx,
    PLT_CNL_C0,
    PLT_CNL_D0,
    PLT_ICL,
    PLT_ICL_C0,
    PLT_ICL_D0,
    PLT_LKF_Ax,
    PLT_LKF_Bx,
    PLT_TGL_A0,
    PLT_TGL_Bx,
    PLT_TGL_H_A0,
    PLT_JSL
} PLT_VER;

typedef enum _HARDWARE_TYPE
{
    HW_SILICON,
    HW_FPGA,
    HW_SIMICS
} HW_TYPE;

typedef struct
{
    IPU_VER ipuVer;
    PLT_VER pltVer;
    HW_TYPE hwType;
    long    phyLaneMask;
    long    phySpeedMask;
    char    brandName[0x40];
} PLAT_INFO, *PPLAT_INFO;

#define is_slim_ipu(plt_ver) (    \
    plt_ver == PLT_TGL_H_A0    || \
    plt_ver == PLT_JSL            \
)

#define is_lkf_ipu(plt_ver) (       \
    plt_ver == PLT_LKF_Ax       || \
    plt_ver == PLT_LKF_Bx           \
)

#define is_full_ipu(plt_ver) (    \
    (plt_ver >= PLT_TGL_A0) && (plt_ver < PLT_TGL_H_A0)    \
)

#endif
