@echo off
setlocal enabledelayedexpansion
chcp 65001
 
:: ==================================================================
:: Script Name 	: install_Thales.cmd
:: Author 		: Foxconn CNSBG
:: Descriptions : This script is using to install the SDX55 driver via PCIe Interface
:: ==================================================================

:: ==================================================================
:: Global variables
:: ==================================================================
set version=0.0.1.1
set /a ERRORFLAG=0
set /a ContinueFlag=0
set /a RestartFLAGbefore=0 
set /a RestartFLAGafter=0
set /a RestartFLAG=0
set /a Installmethod=0
set /a fotaflag=0

Set block=%~dp0
CD /D "%block%"

:: ==================================================================
:: Check the priviledge first
:: ==================================================================

call :helpmessage
TAKEOWN /F C:\Windows\System32\cmd.exe >nul 2>&1
if %errorLevel% NEQ 0 (
	echo Please run this script with Administrator priviledge !!
	pause
	del install_log.log
	exit /b 0
)

:: ==================================================================
:: Entry Point
:: ==================================================================
reg.exe add "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceOverrides\USB#VID_1E2D&PID_00B4&REV_0300\LocationPaths\*" /v Removable /t REG_DWORD /d 0x00000000 /f
ThalsePCIeSDx55DriverUninstallToolv0.0.2.exe
if exist Src\FOTA (
	rmdir Src\FOTA /s /q 1>>nul 2>>nul
)

call :moduleexist
if %ContinueFlag% EQU 0 (
	if %Installmethod% EQU 0 (
		call :PnpInstallDriversNoModule
		call :JudgeFlag
	) else (
		call :PnpInstallDriversWithModule
		call :JudgeFlag
	)
)
GOTO :EOF
:: ==================================================================
:: Initial the log for install steps
:: ==================================================================
:writelog
set msg=%1

for /f "delims=" %%a in ('powershell get-date -format "{yyyyMMddHHmmss}"') do @set psdate=%%a
echo [%psdate:~0,4%/%psdate:~4,2%/%psdate:~6,2% %psdate:~8,2%:%psdate:~10,2%:%psdate:~12,2%]%msg% >> install_log.log

GOTO :EOF


:: ==================================================================
:: Initial the log for install steps
:: ==================================================================
:helpmessage
cls
echo ==================================================================
echo               Thales SDX55 PCIe Driver install script                  
echo                                                  Version : %version%
echo                                                   Author : Foxconn
echo ==================================================================
CALL :writelog "=================================================================="
CALL :writelog "               Thales SDX55 PCIe Driver install script                 "
CALL :writelog "                                                 Version : %version%"
CALL :writelog "                                                  Author : Foxconn"
CALL :writelog "=================================================================="

GOTO :EOF


:: ==================================================================
:: Check the patch is installed before or not
:: ==================================================================
:moduleexist
devcon status "PCI\VEN_1269&DEV_00B3&SUBSYS_00B31269" | find "matching device" > device_exist.log
for /f "tokens=1,2,3,4" %%i in (device_exist.log) do set ExistDevice=%%i

CALL :writelog "MHIHost ExistDevice : %ExistDevice%"

if "%ExistDevice1%" NEQ "No" (
	CALL :writelog "MHI Device Exist, install drivers step by step !!"
	set /a Installmethod=1
) else (
	CALL :writelog "MHI Device NOT Exist , install drivers at once !!"
)

CALL :writelog "Installmethod : %Installmethod%"

if exist device_exist.log (
	del device_exist.log 1>>nul 2>>nul
)

GOTO :EOF



:: ==================================================================
:: Install all drivers
:: ==================================================================
:PnpInstallDriversNoModule
CALL :writelog "===== Install MhiHost driver ====="
pnputil.exe /add-driver Src\MHI\MhiHost.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [MhiHost] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [MhiHost] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [MhiHost] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [MhiHost] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [MhiHost] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [MhiHost] failed !!"
		set /a ERRORFLAG=1
	)
)
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 2 >> nul

CALL :writelog "===== Install qcude driver ====="
pnputil.exe /add-driver Src\UDE\qcude.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcude] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcude] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcude] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcude] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcude] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcude] failed !!"
		set /a ERRORFLAG=2
	)
)
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 2 >> nul

CALL :writelog "===== Install qmuxmdm driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qmuxmdm.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qmuxmdm] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qmuxmdm] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qmuxmdm] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qmuxmdm] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qmuxmdm] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qmuxmdm] failed !!"
		set /a ERRORFLAG=3
	)
)
echo. >> install_log.log

CALL :writelog "===== Install qcgnss driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qcgnss.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcgnss] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcgnss] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcgnss] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcgnss] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcgnss] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcgnss] failed !!"
		set /a ERRORFLAG=4
	)
)
echo. >> install_log.log

CALL :writelog "===== Install qcmdm driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qcmdm.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcmdm] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcmdm] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcmdm] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcmdm] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcmdm] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcmdm] failed !!"
		set /a ERRORFLAG=5
	)
)
echo. >> install_log.log

CALL :writelog "===== Install qcser driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qcser.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcser] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcser] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcser] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcser] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcser] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcser] failed !!"
		set /a ERRORFLAG=6
	)
)
echo. >> install_log.log

for %%a in (1, 1, 5) DO (
	for /F "tokens=3 delims=: " %%H in ('sc query "SIMService" ^| findstr "        STATE"') do (
		if /I "%%H" NEQ "RUNNING" (
			timeout /t 5 >> nul
		)
	)
)

CALL :writelog "==================== Driver Install Complete ====================5555"
mkdir "C:\ProgramData\Qualcomm® Snapdragon™ X55 5G Modem\INF_Injection_Log" 1>>nul 2>>nul
move /y install_log.log "C:\ProgramData\Qualcomm® Snapdragon™ X55 5G Modem\INF_Injection_Log\" 1>>nul 2>>nul
move /y log.txt "C:\ProgramData\Qualcomm® Snapdragon™ X55 5G Modem\INF_Injection_Log\" 1>>nul 2>>nul

GOTO :EOF






:: ==================================================================
:: Install MhiHost driver
:: ==================================================================
:PnpInstallDriversWithModule
CALL :writelog "===== Install MhiHost driver ====="
pnputil.exe /add-driver Src\MHI\MhiHost.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [MhiHost] successful !!
	CALL :writelog "[STEP  PASS] Install driver [MhiHost] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [MhiHost] successful !!
		CALL :writelog "[STEP  PASS] Install driver [MhiHost] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [MhiHost] failed !!
		CALL :writelog "[STEP  FAIL] Install driver [MhiHost] failed !!"
		set /a ERRORFLAG=1
	)
)

timeout /t 1 >> nul
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 1 >> nul

CALL :writelog "[STEP Check] Checking the MhiHost is running or not !!"
set /a waitcounter=0
:waitforMhiHost
devcon status "PCI\VEN_1269&DEV_00B3&SUBSYS_00B31269" | find "Driver is" > device_status.log
for /f "tokens=1,2,3" %%i in (device_status.log) do set DeviceStatus=%%k
	
CALL :writelog "DeviceStatus : %DeviceStatus%"
if "%DeviceStatus%" == "running." (
	call :qcudeinstaller
) else (
	if %waitcounter% LEQ 10 (
		set /a waitcounter=%waitcounter% + 1
		timeout /t 1 >> nul
		call :waitforMhiHost
	) else (
		CALL :writelog "[ Critical ] **********************************************"
		CALL :writelog "[ Critical ] MHIHost status is abnormal, please check it !!"
		CALL :writelog "[ Critical ] **********************************************"
		call :qcudeinstaller
	)
)

del device_status.log 1>>nul 2>>nul

GOTO :EOF

:: ==================================================================
:: Install qcude driver
:: ==================================================================
:qcudeinstaller
CALL :writelog "===== Install qcude driver ====="
pnputil.exe /add-driver Src\UDE\qcude.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcude] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcude] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcude] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcude] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcude] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcude] failed !!"
		set /a ERRORFLAG=2
	)
)

timeout /t 1 >> nul
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 1 >> nul

CALL :writelog "[STEP Check] Checking the qcude is running or not !!"
set /a waitcounter=0
:waitforqcude
devcon status "{3a4d657c-0a42-4501-9627-ba1b76ffc39d}\QcUde-00B31269" | find "Driver is" > device_status.log
for /f "tokens=1,2,3" %%i in (device_status.log) do set DeviceStatus=%%k

CALL :writelog "DeviceStatus : %DeviceStatus%"
if "%DeviceStatus%" == "running." (
	call :qmuxmdminstaller
) else (
	if %waitcounter% LEQ 10 (
		set /a waitcounter=%waitcounter% + 1
		timeout /t 1 >> nul
		call :waitforqcude
	) else (
		CALL :writelog "[ Critical ] ********************************************"
		CALL :writelog "[ Critical ] qcude status is abnormal, please check it !!"
		CALL :writelog "[ Critical ] ********************************************"
		call :qmuxmdminstaller
	)
)

del device_status.log 1>>nul 2>>nul

GOTO :EOF


:: ==================================================================
:: Install qmuxmdm driver
:: ==================================================================
:qmuxmdminstaller
CALL :writelog "===== Install qmuxmdm driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qmuxmdm.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qmuxmdm] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qmuxmdm] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qmuxmdm] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qmuxmdm] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qmuxmdm] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qmuxmdm] failed !!"
		set /a ERRORFLAG=3
	)
)

timeout /t 1 >> nul
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 1 >> nul

CALL :writelog "[STEP Check] Checking the qmuxmdm is running or not !!"
set /a waitcounter=0
:waitforqmuxmdm
devcon status "USB\VID_1E2D&PID_00B4&MI_02" | find "Driver is" > device_status.log
for /f "tokens=1,2,3" %%i in (device_status.log) do set DeviceStatus=%%k

CALL :writelog "DeviceStatus : %DeviceStatus%"
if "%DeviceStatus%" == "running." (
	call :qcgnssinstaller
) else (
	if %waitcounter% LEQ 10 (
		set /a waitcounter=%waitcounter% + 1
		timeout /t 1 >> nul
		call :waitforqmuxmdm
	) else (
		CALL :writelog "[ Critical ] **********************************************"
		CALL :writelog "[ Critical ] qmuxmdm status is abnormal, please check it !!"
		CALL :writelog "[ Critical ] **********************************************"
		call :qcgnssinstaller
	)
)

del device_status.log 1>>nul 2>>nul

GOTO :EOF


:: ==================================================================
:: Install qcgnss driver
:: ==================================================================
:qcgnssinstaller
CALL :writelog "===== Install qcgnss driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qcgnss.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcgnss] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcgnss] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcgnss] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcgnss] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcgnss] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcgnss] failed !!"
		set /a ERRORFLAG=4
	)
)

timeout /t 1 >> nul
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 1 >> nul

CALL :writelog "[STEP Check] Checking the qcgnss is running or not !!"
set /a waitcounter=0
:waitforqcgnss
devcon status "{7DCB3244-C836-4A0C-A1E9-BD68D385AA2B}\VID_1E2D&PID_00B4_QCGNSS" | find "Driver is" > device_status.log
for /f "tokens=1,2,3" %%i in (device_status.log) do set DeviceStatus=%%k

CALL :writelog "DeviceStatus : %DeviceStatus%"
if "%DeviceStatus%" == "running." (
	call :qcmdminstaller
) else (
	if %waitcounter% LEQ 10 (
		set /a waitcounter=%waitcounter% + 1
		timeout /t 1 >> nul
		call :waitforqcgnss
	) else (
		CALL :writelog "[ Critical ] *********************************************"
		CALL :writelog "[ Critical ] qcgnss status is abnormal, please check it !!"
		CALL :writelog "[ Critical ] *********************************************"
		call :qcmdminstaller
	)
)

del device_status.log 1>>nul 2>>nul

GOTO :EOF


:: ==================================================================
:: Install qcmdm driver
:: ==================================================================
:qcmdminstaller
CALL :writelog "===== Install qcmdm driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qcmdm.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcmdm] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcmdm] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcmdm] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcmdm] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcmdm] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcmdm] failed !!"
		set /a ERRORFLAG=5
	)
)

timeout /t 1 >> nul
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 1 >> nul

call :qcserinstaller

GOTO :EOF

:: ==================================================================
:: Install qcser driver
:: ==================================================================
:qcserinstaller
CALL :writelog "===== Install qcser driver ====="
pnputil.exe /add-driver Src\QUD_GNSS\qcser.inf /install > driver_temp.log
if %ERRORLEVEL% EQU 0 (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	echo [STEP  PASS] Install driver [qcser] successful !!
	echo. >> install_log.log
	CALL :writelog "[STEP  PASS] Install driver [qcser] successful !!"
) else (
	for /f "tokens=*" %%a in ('find /C "up-to-date" ^< "driver_temp.log"') do set DriverResult=%%a
	type driver_temp.log >> install_log.log
	CALL :writelog "Count the string "up-to-date" [!DriverResult!] !!"
	del driver_temp.log 1>>nul 2>>nul
	if !DriverResult! NEQ 0 (
		echo [STEP  PASS] Install driver [qcser] successful !!
		echo. >> install_log.log
		CALL :writelog "[STEP  PASS] Install driver [qcser] successful !!"
	) else (
		echo [STEP  FAIL] Install driver [qcser] failed !!
		echo. >> install_log.log
		CALL :writelog "[STEP  FAIL] Install driver [qcser] failed !!"
		set /a ERRORFLAG=6
	)
)

timeout /t 1 >> nul
echo. >> install_log.log
devcon rescan 1>>nul 2>>nul
timeout /t 1 >> nul

call :movelogtopath
GOTO :EOF



:: ==================================================================
:: Copy file to backup folder update
:: ==================================================================
:movelogtopath
CALL :writelog "==================== Driver Install Complete==================45=="
mkdir "C:\ProgramData\Qualcomm® Snapdragon™ X55 5G Modem\INF_Injection_Log" 1>>nul 2>>nul
move /y log.txt "C:\ProgramData\Qualcomm® Snapdragon™ X55 5G Modem\INF_Injection_Log\" 1>>nul 2>>nul
move /y install_log.log "C:\ProgramData\Qualcomm® Snapdragon™ X55 5G Modem\INF_Injection_Log\" 1>>nul 2>>nul
GOTO :EOF







:: ==================================================================
:: Judge for ERRORFLAG
:: ==================================================================
:JudgeFlag
echo.
echo.
if %ERRORFLAG% EQU 0 (
	echo [FinalResult] PASS
) else (
	echo [FinalResult] FAIL : Please check the log for more detail steps !!
)
GOTO :EOF


