/*******************************************************************************
** INTEL CONFIDENTIAL
**
** Copyright (c) 2020-2023 Intel Corporation All Rights Reserved
**
** This software and the related documents are Intel copyrighted materials,
** and your use of them is governed by the express license under which they
** were provided to you ("License"). Unless the License provides otherwise,
** you may not use, modify, copy, publish, distribute, disclose or transmit
** this software or the related documents without Intel's prior written
** permission.
**
** The source code contained or described herein and all documents related to
** the source code ("Material") are owned by Intel Corporation or its suppliers
** or licensors.
**
** This software and the related documents are provided as is,
** with no express or implied warranties, other than those that are expressly
** stated in the License.
**
*******************************************************************************/

#include "IpfProvider.h"
#include "SampleBatteryProvider.h"

static std::string manifest = R"(
{
  "schema_type": "provider_manifest",
  "schema_revision": 5,
  "body": {
    "Company.Org.Battery": {
      "unique_id": "7A93D4B2-140D-4435-A7AF-ACFA889C3FB3",
      "version": "0.1",
      "author": "XYZ",
      "description": "Provider for Battery example.",
      "attach": [ {"location": "Platform.Extension", "name": "Battery", "init": {"Manufacturer": "BatteryManufacturer"}}]
    }
  }
}
)";

static Ipf::ProviderMap factory = {
	{"Company.Org.Battery", Ipf::ProviderMapEntry<Ipf::SampleBatteryProvider>},
};

EXPORT_PROVIDER(Ipf::ProviderApi(manifest, factory))
