import json
import os
import ClientApiPy

if os.name == "nt":
	config = {
			"schema_type": "provider_config",
			"schema_revision": 1,
			"body": {
				"local_providers": [
						"SampleCameraProvider.dll",
						"SampleBatteryProvider.dll"
				],	
				"init": {
					"Company.Org.Battery":
						{                           
							"Manufacturer": "UpdatedBatteryManufacturer",
							"Model": "MUO6"
						}
				}
			}
		}
else:
	config = {
			"schema_type": "provider_config",
			"schema_revision": 1,
			"body": {
				"local_providers": [
						"libSampleCameraProvider.so",
						"libSampleBatteryProvider.so"
				],	
				"init": {
					"Company.Org.Battery":
						{                           
							"Manufacturer": "UpdatedBatteryManufacturer",
							"Model": "MUO6"
						}
				}
			}
		}


# An object that can be passed to RegisterEvent as context.
class ContextObject:
	def Hello(self, event_data):
		print("Hello from ContextObject! Event data is ", event_data)

# Function to be called in case of provider event.
def CallbackFunction(path, event, context):
	print("Received event from ", path , ". Event data: ", event)
	if context:
		context.Hello(event)

def main():

	try:
		# Load and initialize providers
		ipf = ClientApiPy.ClientApiPyJson(config)

		# Get ClientApi Properties
		jsonStream = ipf.GetProperties()
		print("ipf.GetProperties()\n", json.dumps(jsonStream, indent = 4))

		# Get objects and properties under Platform
		jsonStream = ipf.GetNode("Platform")
		print("ipf.GetNode(\"Platform\")\n", json.dumps(jsonStream, indent = 4))

		# Get all objects and properties under Camera Provider
		jsonStream = ipf.GetNode("Platform.Extension.Camera")
		print("ipf.GetNode(\"Platform.Extension.Camera\")\n", json.dumps(jsonStream, indent = 4))

		# Get Data Schema for Camera Provider
		result = ipf.GetSchema("Platform.Extension.Camera", ClientApiPy.SchemaType.DATA)
		print("ipf.GetSchema(\"Platform.Extension.Camera\")\n", json.dumps(result, indent = 4))

		# Query node to get objects and properties at any level in the node tree
		queryResult = ipf.QueryNode("Platform.Extension.Camera")
		print("ipf.QueryNode(\"Platform.Extension.Camera\")\n", json.dumps(queryResult, indent = 4))

		# Set fps property of Camera
		ipf.SetValue("Platform.Extension.Camera.Fps", 100)

		# Get fps property from Camera
		updatedFps = ipf.GetValue("Platform.Extension.Camera.Fps")
		print("ipf.GetValue(\"Platform.Extension.Camera.Fps\")\n", str(updatedFps))

		# Get init parameter information from Battery provider
		jsonStream = ipf.GetNode("Platform.Extension.Battery")
		print("ipf.GetNode(\"Platform.Extension.Battery\")\n", json.dumps(jsonStream, indent = 4))

		# Get manufacturer information which is a init parameter
		jsonStream = ipf.GetNode("Platform.Extension.Battery.Manufacturer")
		print("ipf.GetNode(\"Platform.Extension.Battery.Manufacturer\")\n", json.dumps(jsonStream, indent = 4))
		# Set state (enum) property of Battery
		ipf.SetValue("Platform.Extension.Battery.State", "charged")

		try:
			ipf.SetValue("Platform.Extension.Battery.IsIonBattery", True)
		except ClientApiPy.IpfException as e:
			print("Set value is not supported")
			print("Error message is : \n", str(e))

		# Get state from Battery 
		updatedState = ipf.GetValue("Platform.Extension.Battery.State")
		print("ipf.GetValue(\"Platform.Extension.Battery.State\")\n", updatedState)

		# Get child property value under Battery Provider
		childState = ipf.GetValue("Platform.Extension.Battery.ChildCell.State")
		print("ipf.GetValue(\"Platform.Extension.Battery.ChildCell.State\")\n", childState)

		# To pass a context to RegisterEvent, create an object of context and pass to RegisterEvent as an argument 
		conobj = ContextObject()
		ipf.RegisterEvent("Platform.Extension.Battery.BatteryFullyCharged", CallbackFunction, conobj)

		# Execute a command
		cmdobj = {"CommandName" : "value1"}
		result = ipf.ExecuteCommand("Platform.Extension.Battery", cmdobj)
		print("Result of ipf.ExecuteCommand(\"Platform.Extension.Battery, cmdobj\")\n", json.dumps(result, indent = 4))

		# Unregister for the event
		ipf.UnregisterEvent("Platform.Extension.Battery.BatteryFullyCharged", CallbackFunction)

		cmd_simulate_plug = {"SimulatePlug" : {"InstanceName" : "ChildBatteryProvider", "Manufacturer" : "Intel", "Model" : "I123X"}}

		cmd_simulate_unplug = {"SimulateUnplug" : {"InstanceName" : "ChildBatteryProvider"}}

		# Execute command creates a child provider with "ChildBatteryProvider" instance name
		result = ipf.ExecuteCommand("Platform.Extension.Battery", cmd_simulate_plug)
		print("ipf.ExecuteCommand(\"Platform.Extension.Battery, cmd_simulate_plug = \")\n", json.dumps(result, indent = 4))

		# Call child provider's execute command
		result = ipf.ExecuteCommand("Platform.Extension.Battery.ChildBatteryProvider", cmd_simulate_plug)
		print("ipf.ExecuteCommand(\"Platform.Extension.Battery.ChildBatteryProvider , cmd_simulate_plug = \")\n",  json.dumps(result, indent = 4))

		result = ipf.ExecuteCommand("Platform.Extension.Battery", cmd_simulate_unplug)
		print("ipf.ExecuteCommand(\"Platform.Extension.Battery , cmd_simulate_unplug = \")\n", json.dumps(result, indent = 4))

	except ClientApiPy.IpfException as e:
		print(str(e))

	except Exception as e:
		print(str(e))

if __name__=="__main__":
    main()
