@echo off
REM :: Intel(R) Innovation Platform Framework Extensible Framework (IPF EF) Certificate tool
REM :: Copyright (c) 2020-2023 Intel Corporation All Rights Reserved
REM ::
REM :: This script is used to manage self-signed certificates for Developer testing
REM :: since the IPF EF Framework binaries installed by the INF package requires that all
REM :: Provider DLLs be Digitally Signed.
REM ::
REM :: Run "certgen help" for command line options
REM ::
pushd %~dp0
setlocal
set CERTNAME=ipftest
set CERTCOMMENT=IPF Test Certificate
if not "%2"=="" set CERTNAME=%2
if not "%~3"=="" set CERTCOMMENT=%~3
for %%p in (help -help --help -h /help /h) do if /i "%1"=="%%p" (
	call :help
	goto exit
)

REM :: Try to load Visual Studio command line environment if necessary so we can use Certificate Generation tools
where makecert.exe 2>nul >nul
if errorlevel 1 if "%VisualStudioVersion%"=="" call "%ProgramFiles(x86)%\Microsoft Visual Studio\2019\Professional\VC\Auxiliary\Build\vcvarsall.bat" x64 >nul 2>nul

if "%1"=="" (call :create pause) else (
if /i "%1"=="create" (call :create) else (
if /i "%1"=="generate" (call :generate) else (
if /i "%1"=="install" (call :install) else (
if /i "%1"=="uninstall" (call :uninstall) else (
if /i "%1"=="delete" (call :delete) else (
call :help
))))))
goto exit

:help
echo certgen - IPF Extensible Framework Test Certificate Generation Tool
echo Copyright (c) 2020-2023 Intel Corporation All Rights Reserved
echo.
echo Usage: certgen [option] [certname] [Certificate Comment]
echo Options:
echo   create    = Create New Self-signed Test Certificate and Install into Trusted Root Store
echo   generate  = Create New Self-signed Test Certificate but do not Install into Store
echo   install   = Install Existing Test Certificate into Trusted Root Store
echo   uninstall = Remove Test Certificate from Trusted Root Store
echo   delete    = Remove Test Certificate from Trusted Root Store and Delete Certificate files
echo.
echo Defaults:
echo   option    = create
echo   certname  = %CERTNAME%
echo   Comment   = %CERTCOMMENT%
echo.
echo Note: Windows WDK is required to generate and sign with Test Certificates
echo Note: This script requires Administrator privileges (Run As Administrator)
exit /b

REM : Note: If the Certificate is Password-protected, you will be prompted to enter it several times when creating it, but not when signing with it

REM : Create New Certificate and add to Trusted Root Store
:create
call :delete
call :generate
call :install
if /i "%1"=="pause" (
	echo ***
	echo *** Test Certificate Successfully Generated and Installed
	echo ***
	pause
)
exit /b

REM : Create New Certificate only
:generate
if exist %CERTNAME%.* del %CERTNAME%.*
if exist %CERTNAME%.* goto error
makecert -n "CN=%CERTCOMMENT%" /r /h 0 /eku "1.3.6.1.5.5.7.3.3,1.3.6.1.4.1.311.10.3.13" /a sha512 /e 12/31/2099 /sv %CERTNAME%.pvk %CERTNAME%.cer
if %ERRORLEVEL% NEQ 0 goto error
pvk2pfx -pvk %CERTNAME%.pvk -spc %CERTNAME%.cer -pfx %CERTNAME%.pfx
if %ERRORLEVEL% NEQ 0 goto error
exit /b

REM : Install Existing Certificate into Trusted Root Store
:install
call :uninstall
certutil -addstore Root %CERTNAME%.cer
if %ERRORLEVEL% NEQ 0 goto error
exit /b

REM : Uninstall Existing Certificate from Trusted Root Store
:uninstall
certutil -delstore Root "%CERTCOMMENT%"
if %ERRORLEVEL% NEQ 0 goto error
exit /b

REM : Remove Certificate from Trusted Root Store and Delete Certificate
:delete
call :uninstall
if exist %CERTNAME%.* del %CERTNAME%.*
if exist %CERTNAME%.* goto error
exit /b

:error
echo ***
echo *** ERRORS DETECTED. This tool requires "Run As Administrator" privileges
echo ***
pause
endlocal
popd
exit

:exit
endlocal
popd