/*******************************************************************************
** INTEL CONFIDENTIAL
**
** Copyright (c) 2020-2023 Intel Corporation All Rights Reserved
**
** This software and the related documents are Intel copyrighted materials,
** and your use of them is governed by the express license under which they
** were provided to you ("License"). Unless the License provides otherwise,
** you may not use, modify, copy, publish, distribute, disclose or transmit
** this software or the related documents without Intel's prior written
** permission.
**
** The source code contained or described herein and all documents related to
** the source code ("Material") are owned by Intel Corporation or its suppliers
** or licensors.
**
** This software and the related documents are provided as is,
** with no express or implied warranties, other than those that are expressly
** stated in the License.
**
*******************************************************************************/

#include <iostream>
#include <memory>
#include <string>
#include <vector>

#include "IpfProvider.h"
#include "SampleCameraProvider.h"

static const std::string kDataSchema = R"(
{
  "$schema": "http://json-schema.org/draft-07/schema#",
  "type": "object",
  "properties": {
    "Manufacturer": {
      "type": "string",
      "readOnly": "true",
	  "description" : "Battery manufacturer name"
    },
    "AutoExposure" : {
        "type": "string",
        "enum": ["on","off"],
		"description" : "Battery auto-exposure"
    },
    "Fps": {
        "type": "integer",
		"description" : "frame per second"
    }
  },
  "required": [
    "Manufacturer"
  ]
}

)";

// Mocked sample driver.
class MockedDriver
{
private:
	int64_t x = 50;

public:
	int64_t getFps()
	{
		return x;
	}

public:
	void setFps(int64_t value)
	{
		x = value;
	}
};

namespace Ipf
{
auto mockedDriver = ::MockedDriver();

static const SchemaMap kSchemaMap = {{SchemaType::DATA, kDataSchema}};

SampleCameraProvider::SampleCameraProvider(IFramework* pfw, const std::string& config)
	: ProviderDelegate(pfw, kSchemaMap, config)
{
	// Initialize data
	namespace_["Manufacturer"] = "ABC";
	namespace_["AutoExposure"] = "off";
	namespace_["Fps"] = mockedDriver.getFps();
}

SampleCameraProvider::~SampleCameraProvider()
{}

// UpdateNamespace is invoked every time a client calls GetNode().
void SampleCameraProvider::UpdateNamespace(const std::string& path)
{
	namespace_["Fps"] = mockedDriver.getFps();
}

void SampleCameraProvider::SetValue(const std::string& property, const int64_t value)
{
	if (property == "Fps") {
		mockedDriver.setFps(value);
	}
}

} // namespace Ipf
