```
*******************************************************************************
** INTEL CONFIDENTIAL
**
** Copyright (c) 2020-2023 Intel Corporation All Rights Reserved
**
** This software and the related documents are Intel copyrighted materials,
** and your use of them is governed by the express license under which they
** were provided to you ("License"). Unless the License provides otherwise,
** you may not use, modify, copy, publish, distribute, disclose or transmit
** this software or the related documents without Intel's prior written
** permission.
**
** The source code contained or described herein and all documents related to
** the source code ("Material") are owned by Intel Corporation or its suppliers
** or licensors.
**
** This software and the related documents are provided as is,
** with no express or implied warranties, other than those that are expressly
** stated in the License.
**
*******************************************************************************
```

# IPF Extensible Framework (IPF-EF) SDK

The Innovation Platform Framework enables applications to easily access platform information using a node-based API.

### Hardware Dependencies
Requires Intel's Alder Lake and newer platforms.

### Software Dependencies
1. Microsoft Windows 10 (Version 20H2 and higher) operating system.
2. .NET Framework 4.7.2
3. CMake build system is used for compilation and installation. The required minimum version is 3.15, which may be downloaded from https://cmake.org/download/
4. For development, Visual Studio 2019 and Visual C++ 2019 are required. Install the C# compiler VS2019 for C# client applications. Also from the Visual Studio Installer include the latest "Spectre-mitigated libs".
5. Install the Windows Driver Kit (WDK) component of Visual Studio. It is used for self-signing of DLLs.
6. Run [VC_Redist.x64.exe](https://docs.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist?view=msvc-170) from Microsoft to ensure Visual Studio Runtime is Version 2019 or later.
7. Install Python 3.10.6 version(https://www.python.org/downloads/release/python-3106/) and add the path to environmental variables.

## Getting Started
Steps to install framework and execute of samples in the SDK.

### Install Framework
Using either of the methods below.

#### Manually from Windows Explorer
1. From the ipf-[version]-windows-setup package,
2. Right clicking & instal all .inf files. Listed below
 * ipf-core-[ver]/drivers/x64/ipf_acpi.inf
 * ipf-core-[ver]/drivers/x64/ipf_cpu.inf
 * ipf-ef-[ver]/drivers/x64/ipf_ef_ext.inf 
 * ipf-ef-[ver]/drivers/x64/ipf_ef_sw.inf

#### From Command Line with Pnputil
1. Open administrator command prompt.
2. Navigate to the ipf-[version]-windows-setup/ipf-core-[ver]/drivers/x64/
3. Run `pnputil /add_driver *inf /install`.
4. Navigate to the ipf-[version]-windows-setup/ipf-ef-[ver]/drivers/x64/
5. Run `pnputil /add_driver *inf /install`.

### Uninstall Framework
1. Run command prompt as administrator. 
2. Find the published names with `pnputil /enum-drivers` command. 
3. Uninstall each inf using `pnputil /delete-driver [name].inf /uninstall`.
  * pnputil /delete-driver ipf_acpi.inf /uninstall
  * pnputil /delete-driver ipf_cpu.inf /uninstall
  * pnputil /delete-driver ipf_ef_ext.inf /uninstall
  * pnputil /delete-driver ipf_ef_sw.inf /uninstall

### One Time Signing Setup
All Provider DLL's, including Local and Debug versions, must be Digitally Signed.
1. Unzip the SDK package contents, ipf-ef-[version]-windows-sdk
2. From tools folder, right-click "certgen.cmd" and select "Run as Administrator". You will be prompted to create an optional certificate password.
3. It is recommended to remove and store ipftest.pvk in a safe place.

Below is an example output, refer to provider guide for further details on signing and certificate distribution.
``` 
Succeeded
Root "Trusted Root Certification Authorities"
CertUtil: -delstore command completed successfully.
Root "Trusted Root Certification Authorities"
Signature matches Public Key
Certificate "IPF Test Certificate" added to store.
CertUtil: -addstore command completed successfully.
***
*** Test Certificate Successfully Generated and Installed
***

```

### Build Sample Providers and Run Client Applications
1. Unzip SDK package contents, ipf-ef-[version]-sdk.zip
2. Launch a Developer Command Prompt for Visual Studio 2019. Run `cmake -S . -B build` from unzipped folder.
3. Run`cmake --build build --config <configuration>` where configuration is `Debug` or `Release`
4. Execute the sample applications
  - `cd build\<configuration>`
  - `SampleClientAppCpp.exe` to run the C++ sample application
  - `SampleClientAppC.exe` to run the C sample application
  - `python SampleClientApp.py` to run the Python sample application

See the section "C# Client Development with .NET 6.0" for instructions to build and run the C# sample application.
   
# Getting Started with Client Application Development

The IPF framework supports C, C++, C# and Python client applications. Sample client applications for these languages are included in `samples\client`. The sample client applications load the sample camera and battery provider as local providers. This means that those shared libraries will be required in the folder where the sample application is run.

Refer to Client Guide for details on Client facing APIs. 

## C# client development with .NET 6.0

This SDK includes a nuget package that allows developers to use the IPF client API from C# .NET applications.  The example project targets net6.0, net48, and net472 frameworks and must be built with the .NET 6.0 SDK.  

To get started, first download and install the .NET 6.0 SDK from Microsoft
https://dotnet.microsoft.com/en-us/download/dotnet/6.0

It is possible to build applications using older frameworks by using the "PackageReference" style of specifying project dependencies.  This method is outside the scope of this README.

### Using the package

The library is included as a NuGet packages in the lib\Debug and lib\Release folders.  To make the NuGet package available to your application:

1. Add the directory containing the NuGet package as a NuGet package source. There are many ways to do this (Visual Studio NuGet options, etc). The easiest is using the dotnet CLI.
  - `dotnet nuget add source c:\<path-to-nupkg-directory> -n intel.ipf.extensibleframework`
2. Add the package to your project.
  - `dotnet add package Intel.Ipf.ExtensibleFramework`
3. Run a build or a restore.
  - `dotnet build`

### Build and run the C# sample application

An example project is included in the samples\client\csharp folder.   

Steps to build the sample application:

1. Add the nuget package source
   - `dotnet nuget add source c:\<path-to-nupkg-directory> -n intel.ipf.extensibleframework`
2. List the NuGet sources and verify that the intel.ipf.extensibleframework source is present and is set to the correct folder.
   - `dotnet nuget list source`
3. Change directory to the sample project directory.  
   - `cd <path-to-ipf-sdk>\samples\client\csharp`
4. Add the Intel.Ipf.ExtensibleFramework package to the project
   - `dotnet add package Intel.Ipf.ExtensibleFramework`
5. Build the project
   - `dotnet build`

The example application loads the SampleCameraProvider and SampleBatteryProvider as local providers. Make sure you have already built the providers using the instructions in the section "Build Sample Providers and Run Client Applications."  

In the following instructions, `<path-to-ipf-sdk>` is the full path to the root of the IPF sdk folder. `<configuration>` may be `Debug` or `Release` and `<target-framework>` may be `net6.0`, `net48`, or `net472`.

1. Copy the provider DLLs to the build output folder.   
  - `cp <path-to-ipf-sdk>\build\<configuraton>\SampleCameraProvider.dll <path-to-ipf-sdk>\samples\client\csharp\<configuration>\Debug\<target-framework>/win-x64`
   - `cp <path-to-ipf-sdk>\build\<configuration>\SampleBatteryProvider.dll <path-to-ipf-sdk>\samples\client\csharp\bin\<configuration>\<target-framework>/win-x64`
2. Change directory to the output directory and run the sample application
   - `cd <path-to-ipf-sdk>\samples\client\csharp\bin\<configration>\<target-framework>/win-x64`
   - `SampleClientApp.exe`

# Getting Started with Provider Development

There are a few sample providers included inside the SDK package at `samples\provider`. Provider developers need to create three files to integrate with IPF.
* [ProviderName]Api.cpp – The framework requires provider developers to define a manifest and declare a factory entry to create provider.
* [ProviderName]Provider.h - [ProviderName]Provider class is inherited from ProviderDelegate. 
* [ProviderName]Provider.cpp – Provider developers implement exposed methods to integrate IPF framework with their own software stacks.

Providers can be installed with INF or tool based methods. Framework also supports local providers for easy development. Refer to Provider Guide for details on provider installation methods and APIs. 


# Troubleshooting Guide
1. Error MSB8040: Spectre-mitigated libraries are required for this project 

    Install latest "Libs for Spectre" from the Visual Studio installer (Individual components tab) for both visual stuido and build tools.

2. Got IpfException when accessing the namespace: Error Locating Framework Directory

   Does software components in device manager have `Intel(R) Innovation Platform Framework Extensible Framework`?

   If it doesn't then re-install framework.

3. Exception when accessing the namespace: Failed to load library: ClientApiProxy.dll : 14 : Incompatible Version
   
   This indicates mismatch between framework and SDK versions. Try installing framework and SDK from same IPF release to fix this.

4. Error(42): Invalid Digital Signature

   Try generating new security certs and signing DLLs again. 

   1. Unzip contents of SDK package, ipf-ef-[version]-sdk
   2. From tools folder, right-click "certgen.cmd" and select "Run as Administrator".
   3. From ipf-ef-[version]-sdk folder, execute `cmake --build build --config Debug` OR `cmake --build build --config Release`

5. Failed to run certgen.cmd

    Run certgen.cmd from Visual Studio 2019 powershell.
    1. Open Developer Powershell or Developer Command Prompt for Visual Studio 2019 as Administrator
    2. Navigate to ipf-ef-[version]-sdk/tools
    3. Run certgen.cmd

6. System Error of either VCRuntime140.dll not found or MSCVP140.dll was not found

   This indicates the VC_redist is not installed. Please run [VC_Redist.x64.exe](https://docs.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist?view=msvc-170) install VC2019 or later. 
